/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import java.util.Map;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.core.dataStructures.hash.IntHashMap;
import jetbrains.exodus.core.dataStructures.hash.ObjectProcedure;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterable;
import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.EntityIterableType;
import jetbrains.exodus.entitystore.EntityIterator;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.PersistentEntityStore;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.EntityIdSet;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableDecoratorBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleDecorator;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.entitystore.iterate.EntityIteratorFixingDecorator;
import jetbrains.exodus.entitystore.iterate.FilterLinksIterable;
import jetbrains.exodus.entitystore.tables.LinkValue;
import jetbrains.exodus.entitystore.tables.PropertyKey;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.util.LightOutputStream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tH\u0016R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ljetbrains/exodus/entitystore/iterate/FilterLinksIterable;", "Ljetbrains/exodus/entitystore/iterate/EntityIterableDecoratorBase;", "txn", "Ljetbrains/exodus/entitystore/PersistentStoreTransaction;", "linkId", "", "source", "Ljetbrains/exodus/entitystore/iterate/EntityIterableBase;", "filter", "Ljetbrains/exodus/entitystore/EntityIterable;", "(Ljetbrains/exodus/entitystore/PersistentStoreTransaction;ILjetbrains/exodus/entitystore/iterate/EntityIterableBase;Ljetbrains/exodus/entitystore/EntityIterable;)V", "getHandleImpl", "Ljetbrains/exodus/entitystore/EntityIterableHandle;", "getIteratorImpl", "Ljetbrains/exodus/entitystore/EntityIterator;", "intersect", "right", "isSortedById", "", "union", "Companion", "xodus-entity-store"})
public final class FilterLinksIterable
extends EntityIterableDecoratorBase {
    private final EntityIterableBase filter;
    private final int linkId;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public EntityIterable intersect(@NotNull EntityIterable right) {
        Intrinsics.checkParameterIsNotNull((Object)right, (String)"right");
        if (right instanceof FilterLinksIterable && this.linkId == ((FilterLinksIterable)right).linkId && this.source == ((FilterLinksIterable)right).source) {
            PersistentStoreTransaction persistentStoreTransaction = this.getTransaction();
            Intrinsics.checkExpressionValueIsNotNull((Object)persistentStoreTransaction, (String)"transaction");
            EntityIterableBase entityIterableBase = this.source;
            Intrinsics.checkExpressionValueIsNotNull((Object)entityIterableBase, (String)"source");
            EntityIterable entityIterable = this.filter.intersect(((FilterLinksIterable)right).filter);
            Intrinsics.checkExpressionValueIsNotNull((Object)entityIterable, (String)"filter.intersect(right.filter)");
            return new FilterLinksIterable(persistentStoreTransaction, this.linkId, entityIterableBase, entityIterable);
        }
        EntityIterable entityIterable = super.intersect(right);
        Intrinsics.checkExpressionValueIsNotNull((Object)entityIterable, (String)"super.intersect(right)");
        return entityIterable;
    }

    @Override
    @NotNull
    public EntityIterable union(@NotNull EntityIterable right) {
        Intrinsics.checkParameterIsNotNull((Object)right, (String)"right");
        if (right instanceof FilterLinksIterable && this.linkId == ((FilterLinksIterable)right).linkId && this.source == ((FilterLinksIterable)right).source) {
            PersistentStoreTransaction persistentStoreTransaction = this.getTransaction();
            Intrinsics.checkExpressionValueIsNotNull((Object)persistentStoreTransaction, (String)"transaction");
            EntityIterableBase entityIterableBase = this.source;
            Intrinsics.checkExpressionValueIsNotNull((Object)entityIterableBase, (String)"source");
            EntityIterable entityIterable = this.filter.union(((FilterLinksIterable)right).filter);
            Intrinsics.checkExpressionValueIsNotNull((Object)entityIterable, (String)"filter.union(right.filter)");
            return new FilterLinksIterable(persistentStoreTransaction, this.linkId, entityIterableBase, entityIterable);
        }
        EntityIterable entityIterable = super.union(right);
        Intrinsics.checkExpressionValueIsNotNull((Object)entityIterable, (String)"super.union(right)");
        return entityIterable;
    }

    @Override
    @NotNull
    public EntityIterator getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        Intrinsics.checkParameterIsNotNull((Object)txn, (String)"txn");
        return new EntityIteratorFixingDecorator(this, new EntityIteratorBase(this, txn, this){
            static final /* synthetic */ KProperty[] $$delegatedProperties;
            private final EntityIteratorBase sourceIt;
            private final IntHashMap<Cursor> usedCursors;
            private final LightOutputStream auxStream;
            private final int[] auxArray;
            private final Lazy idSet$delegate;
            private EntityId nextId;
            final /* synthetic */ FilterLinksIterable this$0;
            final /* synthetic */ PersistentStoreTransaction $txn;

            static {
                $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(getIteratorImpl.1.class), "idSet", "getIdSet()Ljetbrains/exodus/entitystore/iterate/EntityIdSet;"))};
            }

            private final EntityIdSet getIdSet() {
                Lazy lazy = this.idSet$delegate;
                getIteratorImpl.1 var2_2 = this;
                KProperty kProperty = $$delegatedProperties[0];
                return (EntityIdSet)lazy.getValue();
            }

            protected boolean hasNextImpl() {
                if (this.nextId != PersistentEntityId.EMPTY_ID) {
                    return true;
                }
                block0: while (this.sourceIt.hasNext()) {
                    ByteIterable value;
                    EntityId id;
                    this.nextId = id = this.sourceIt.nextId();
                    if (id == null) continue;
                    int typeId = id.getTypeId();
                    Cursor cursor = (Cursor)this.usedCursors.get(typeId);
                    if (cursor == null) {
                        cursor = this.getStore().getLinksFirstIndexCursor(this.$txn, typeId);
                        Map map = (Map)this.usedCursors;
                        Integer n = typeId;
                        Cursor cursor2 = cursor;
                        map.put(n, cursor2);
                    }
                    if ((value = cursor.getSearchKey((ByteIterable)PropertyKey.propertyKeyToEntry(this.auxStream, this.auxArray, id.getLocalId(), FilterLinksIterable.access$getLinkId$p(this.this$0)))) == null) continue;
                    EntityIdSet entityIdSet = this.getIdSet();
                    LinkValue linkValue = LinkValue.entryToLinkValue(value);
                    Intrinsics.checkExpressionValueIsNotNull((Object)linkValue, (String)"LinkValue.entryToLinkValue(value)");
                    if (entityIdSet.contains(linkValue.getEntityId())) {
                        return true;
                    }
                    while (cursor.getNext()) {
                        PropertyKey propKey;
                        PropertyKey propertyKey = propKey = PropertyKey.entryToPropertyKey(cursor.getKey());
                        Intrinsics.checkExpressionValueIsNotNull((Object)propertyKey, (String)"propKey");
                        if (propertyKey.getEntityLocalId() != id.getLocalId() || propKey.getPropertyId() != FilterLinksIterable.access$getLinkId$p(this.this$0)) continue block0;
                        EntityIdSet entityIdSet2 = this.getIdSet();
                        LinkValue linkValue2 = LinkValue.entryToLinkValue(cursor.getValue());
                        Intrinsics.checkExpressionValueIsNotNull((Object)linkValue2, (String)"LinkValue.entryToLinkValue(cursor.value)");
                        if (!entityIdSet2.contains(linkValue2.getEntityId())) continue;
                        return true;
                    }
                }
                return false;
            }

            @Nullable
            protected EntityId nextIdImpl() {
                EntityId result = this.nextId;
                this.nextId = PersistentEntityId.EMPTY_ID;
                return result;
            }

            public boolean dispose() {
                this.sourceIt.disposeIfShouldBe();
                return super.dispose() && this.usedCursors.forEachValue((ObjectProcedure)getIteratorImpl.dispose.1.INSTANCE);
            }
            {
                this.this$0 = $outer;
                this.$txn = $captured_local_variable$1;
                super($super_call_param$2);
                EntityIterator entityIterator = $outer.source.iterator();
                if (entityIterator == null) {
                    throw new TypeCastException("null cannot be cast to non-null type jetbrains.exodus.entitystore.iterate.EntityIteratorBase");
                }
                this.sourceIt = (EntityIteratorBase)entityIterator;
                this.usedCursors = new IntHashMap(6, 2.0f);
                this.auxStream = new LightOutputStream();
                this.auxArray = new int[8];
                this.idSet$delegate = LazyKt.lazy((Function0)((Function0)new Function0<EntityIdSet>(this){
                    final /* synthetic */ getIteratorImpl.1 this$0;

                    @NotNull
                    public final EntityIdSet invoke() {
                        return FilterLinksIterable.access$getFilter$p(this.this$0.this$0).toSet(this.this$0.$txn);
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }));
                this.nextId = PersistentEntityId.EMPTY_ID;
            }
        });
    }

    @Override
    @NotNull
    protected EntityIterableHandle getHandleImpl() {
        PersistentEntityStore persistentEntityStore = this.getStore();
        EntityIterableBase entityIterableBase = this.source;
        Intrinsics.checkExpressionValueIsNotNull((Object)entityIterableBase, (String)"source");
        return new EntityIterableHandleDecorator(this, persistentEntityStore, EntityIterableType.FILTER_LINKS, entityIterableBase.getHandle()){
            private final int[] linkIds;
            final /* synthetic */ FilterLinksIterable this$0;

            @NotNull
            public int[] getLinkIds() {
                return this.linkIds;
            }

            public void toString(@NotNull StringBuilder builder) {
                Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
                super.toString(builder);
                builder.append(FilterLinksIterable.access$getLinkId$p(this.this$0));
                builder.append('-');
                this.applyDecoratedToBuilder(builder);
                builder.append('-');
                EntityIterableHandle entityIterableHandle = FilterLinksIterable.access$getFilter$p(this.this$0).getHandle();
                if (entityIterableHandle == null) {
                    throw new TypeCastException("null cannot be cast to non-null type jetbrains.exodus.entitystore.iterate.EntityIterableHandleBase");
                }
                ((EntityIterableHandleBase)entityIterableHandle).toString(builder);
            }

            public void hashCode(@NotNull EntityIterableHandleBase.EntityIterableHandleHash hash) {
                Intrinsics.checkParameterIsNotNull((Object)hash, (String)"hash");
                hash.apply(FilterLinksIterable.access$getLinkId$p(this.this$0));
                hash.applyDelimiter();
                super.hashCode(hash);
                hash.applyDelimiter();
                hash.apply(FilterLinksIterable.access$getFilter$p(this.this$0).getHandle());
            }

            public boolean isMatchedLinkAdded(@NotNull EntityId source, @NotNull EntityId target, int linkId) {
                Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
                Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
                return linkId == FilterLinksIterable.access$getLinkId$p(this.this$0) || this.decorated.isMatchedLinkAdded(source, target, linkId) || FilterLinksIterable.access$getFilter$p(this.this$0).getHandle().isMatchedLinkAdded(source, target, linkId);
            }

            public boolean isMatchedLinkDeleted(@NotNull EntityId source, @NotNull EntityId target, int linkId) {
                Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
                Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
                return linkId == FilterLinksIterable.access$getLinkId$p(this.this$0) || this.decorated.isMatchedLinkDeleted(source, target, linkId) || FilterLinksIterable.access$getFilter$p(this.this$0).getHandle().isMatchedLinkDeleted(source, target, linkId);
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
                int[] nArray = new int[]{FilterLinksIterable.access$getLinkId$p($outer)};
                EntityIterableHandleBase entityIterableHandleBase = this.decorated;
                Intrinsics.checkExpressionValueIsNotNull((Object)entityIterableHandleBase, (String)"decorated");
                int[] nArray2 = entityIterableHandleBase.getLinkIds();
                EntityIterableHandle entityIterableHandle = FilterLinksIterable.access$getFilter$p($outer).getHandle();
                Intrinsics.checkExpressionValueIsNotNull((Object)entityIterableHandle, (String)"filter.handle");
                this.linkIds = EntityIterableHandleDecorator.mergeFieldIds(nArray, EntityIterableHandleDecorator.mergeFieldIds(nArray2, entityIterableHandle.getLinkIds()));
            }
        };
    }

    @Override
    public boolean isSortedById() {
        EntityIterableBase entityIterableBase = this.source;
        Intrinsics.checkExpressionValueIsNotNull((Object)entityIterableBase, (String)"source");
        return entityIterableBase.isSortedById();
    }

    public FilterLinksIterable(@NotNull PersistentStoreTransaction txn, int linkId, @NotNull EntityIterableBase source, @NotNull EntityIterable filter) {
        Intrinsics.checkParameterIsNotNull((Object)txn, (String)"txn");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)filter, (String)"filter");
        super(txn, source);
        this.linkId = linkId;
        EntityIterableBase entityIterableBase = ((EntityIterableBase)filter).getSource();
        Intrinsics.checkExpressionValueIsNotNull((Object)entityIterableBase, (String)"(filter as EntityIterableBase).source");
        this.filter = entityIterableBase;
    }

    static {
        EntityIterableBase.registerType(EntityIterableType.FILTER_LINKS, Companion.1.INSTANCE);
    }

    public static final /* synthetic */ int access$getLinkId$p(FilterLinksIterable $this) {
        return $this.linkId;
    }

    @NotNull
    public static final /* synthetic */ EntityIterableBase access$getFilter$p(FilterLinksIterable $this) {
        return $this.filter;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/exodus/entitystore/iterate/FilterLinksIterable$Companion;", "", "()V", "xodus-entity-store"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

