/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.EntityIterableType;
import jetbrains.exodus.entitystore.EntityIterator;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableDecoratorBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleDecorator;
import jetbrains.exodus.entitystore.iterate.EntityIterableInstantiator;
import org.jetbrains.annotations.NotNull;

public final class EntityReverseIterable
extends EntityIterableDecoratorBase {
    public EntityReverseIterable(@NotNull PersistentStoreTransaction txn, @NotNull EntityIterableBase source) {
        super(txn, source);
    }

    public static EntityIterableType getType() {
        return EntityIterableType.REVERSE;
    }

    @Override
    public int getEntityTypeId() {
        return this.source.getEntityTypeId();
    }

    @Override
    public boolean isEmpty() {
        return this.source.isEmpty();
    }

    @Override
    public long size() {
        return this.source.size();
    }

    @Override
    public long getRoughCount() {
        return this.source.getRoughCount();
    }

    @Override
    public long getRoughSize() {
        return this.source.getRoughSize();
    }

    @Override
    @NotNull
    public EntityIterator getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        try {
            return this.source.asProbablyCached().getReverseIteratorImpl(txn);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return this.source.getOrCreateCachedInstance(txn).getReverseIteratorImpl(txn);
        }
    }

    @Override
    @NotNull
    protected EntityIterableHandle getHandleImpl() {
        return new EntityIterableHandleDecorator(this.getStore(), EntityReverseIterable.getType(), this.source.getHandle()){

            @Override
            public void toString(@NotNull StringBuilder builder) {
                super.toString(builder);
                this.applyDecoratedToBuilder(builder);
            }

            @Override
            public int getEntityTypeId() {
                return EntityReverseIterable.this.source.getEntityTypeId();
            }
        };
    }

    @Override
    protected long countImpl(@NotNull PersistentStoreTransaction txn) {
        return this.source.size();
    }

    static {
        EntityReverseIterable.registerType(EntityReverseIterable.getType(), new EntityIterableInstantiator(){

            @Override
            public EntityIterableBase instantiate(PersistentStoreTransaction txn, PersistentEntityStoreImpl store, Object[] parameters) {
                return new EntityReverseIterable(txn, (EntityIterableBase)parameters[0]);
            }
        });
    }
}

