/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import java.util.ArrayList;
import java.util.Collection;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.core.dataStructures.LongArrayList;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.EntityIterableType;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.CachedInstanceIterable;
import jetbrains.exodus.entitystore.iterate.ConstantEntityIterableHandle;
import jetbrains.exodus.entitystore.iterate.EntitiesWithCertainLinkIterable;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleBase;
import jetbrains.exodus.entitystore.iterate.LinksIteratorWithTarget;
import jetbrains.exodus.entitystore.iterate.cached.SingleTypeUnsortedEntityIdArrayCachedInstanceIterable;
import jetbrains.exodus.entitystore.tables.LinkValue;
import jetbrains.exodus.entitystore.tables.PropertyKey;
import jetbrains.exodus.env.Cursor;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0003\u0017\u0018\u0019B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0014J\b\u0010\f\u001a\u00020\u0005H\u0016J\b\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0015\u0010\u0014\u001a\u00070\u0015\u00a2\u0006\u0002\b\u00162\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001a"}, d2={"Ljetbrains/exodus/entitystore/iterate/EntitiesWithCertainLinkIterable;", "Ljetbrains/exodus/entitystore/iterate/EntityIterableBase;", "txn", "Ljetbrains/exodus/entitystore/PersistentStoreTransaction;", "entityTypeId", "", "linkId", "(Ljetbrains/exodus/entitystore/PersistentStoreTransaction;II)V", "getLinkId$xodus_entity_store", "()I", "createCachedInstance", "Ljetbrains/exodus/entitystore/iterate/CachedInstanceIterable;", "getEntityTypeId", "getHandleImpl", "Ljetbrains/exodus/entitystore/EntityIterableHandle;", "getIteratorImpl", "Ljetbrains/exodus/entitystore/iterate/LinksIteratorWithTarget;", "getReverseIteratorImpl", "isSortedById", "", "openCursor", "Ljetbrains/exodus/env/Cursor;", "Lorg/jetbrains/annotations/NotNull;", "CachedLinksIterable", "Companion", "LinksIterator", "xodus-entity-store"})
public final class EntitiesWithCertainLinkIterable
extends EntityIterableBase {
    private final int entityTypeId;
    private final int linkId;
    public static final Companion Companion = new Companion(null);

    @Override
    public int getEntityTypeId() {
        return this.entityTypeId;
    }

    @Override
    @NotNull
    public LinksIteratorWithTarget getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        Intrinsics.checkParameterIsNotNull((Object)txn, (String)"txn");
        return new LinksIterator(this, txn, false, 2, null);
    }

    @Override
    @NotNull
    public LinksIteratorWithTarget getReverseIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        Intrinsics.checkParameterIsNotNull((Object)txn, (String)"txn");
        return new LinksIterator(this, txn, true);
    }

    @Override
    @NotNull
    protected EntityIterableHandle getHandleImpl() {
        return new ConstantEntityIterableHandle(this, this.getStore(), Companion.getType()){
            final /* synthetic */ EntitiesWithCertainLinkIterable this$0;

            @NotNull
            public int[] getLinkIds() {
                return new int[]{this.this$0.getLinkId$xodus_entity_store()};
            }

            public void toString(@NotNull StringBuilder builder) {
                Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
                super.toString(builder);
                builder.append('-');
                builder.append(this.getEntityTypeId());
                builder.append('-');
                builder.append(this.this$0.getLinkId$xodus_entity_store());
            }

            public void hashCode(@NotNull EntityIterableHandleBase.EntityIterableHandleHash hash) {
                Intrinsics.checkParameterIsNotNull((Object)hash, (String)"hash");
                hash.applyDelimiter();
                hash.apply(this.getEntityTypeId());
                hash.applyDelimiter();
                hash.apply(this.this$0.getLinkId$xodus_entity_store());
            }

            public int getEntityTypeId() {
                return EntitiesWithCertainLinkIterable.access$getEntityTypeId$p(this.this$0);
            }

            public boolean isMatchedLinkAdded(@NotNull EntityId source, @NotNull EntityId target, int linkId) {
                Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
                Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
                return this.getEntityTypeId() == source.getTypeId() && this.this$0.getLinkId$xodus_entity_store() == linkId;
            }

            public boolean isMatchedLinkDeleted(@NotNull EntityId source, @NotNull EntityId target, int linkId) {
                Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
                Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
                return this.isMatchedLinkAdded(source, target, linkId);
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2);
            }
        };
    }

    @Override
    public boolean isSortedById() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected CachedInstanceIterable createCachedInstance(@NotNull PersistentStoreTransaction txn) {
        void $receiver$iv;
        CachedLinksIterable cachedLinksIterable;
        Intrinsics.checkParameterIsNotNull((Object)txn, (String)"txn");
        LongArrayList localIds = new LongArrayList();
        ArrayList<EntityId> targets = new ArrayList<EntityId>();
        LinksIteratorWithTarget it = this.getIteratorImpl(txn);
        long min = Long.MAX_VALUE;
        long max = Long.MIN_VALUE;
        while (it.hasNext()) {
            EntityId entityId = it.nextId();
            if (entityId == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)entityId, (String)"it.nextId()!!");
            long localId = entityId.getLocalId();
            localIds.add(localId);
            targets.add(it.getTargetId());
            if (min > localId) {
                min = localId;
            }
            if (max >= localId) continue;
            max = localId;
        }
        long[] lArray = localIds.toArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)lArray, (String)"localIds.toArray()");
        Collection localId = targets;
        long[] lArray2 = lArray;
        PersistentStoreTransaction persistentStoreTransaction = txn;
        EntitiesWithCertainLinkIterable entitiesWithCertainLinkIterable = this;
        CachedLinksIterable cachedLinksIterable2 = cachedLinksIterable;
        CachedLinksIterable cachedLinksIterable3 = cachedLinksIterable;
        void thisCollection$iv = $receiver$iv;
        EntityId[] entityIdArray = thisCollection$iv.toArray(new EntityId[0]);
        if (entityIdArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        EntityId[] entityIdArray2 = entityIdArray;
        cachedLinksIterable2(persistentStoreTransaction, lArray2, entityIdArray2, min, max);
        return cachedLinksIterable3;
    }

    private final Cursor openCursor(PersistentStoreTransaction txn) {
        return this.getStore().getLinksSecondIndexCursor(txn, this.entityTypeId);
    }

    public final int getLinkId$xodus_entity_store() {
        return this.linkId;
    }

    public EntitiesWithCertainLinkIterable(@NotNull PersistentStoreTransaction txn, int entityTypeId, int linkId) {
        Intrinsics.checkParameterIsNotNull((Object)txn, (String)"txn");
        super(txn);
        this.entityTypeId = entityTypeId;
        this.linkId = linkId;
    }

    static {
        EntityIterableBase.registerType(Companion.getType(), Companion.1.INSTANCE);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0010\u001a\u00020\u0005H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\n\u0010\u0013\u001a\u0004\u0018\u00010\nH\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@RX\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Ljetbrains/exodus/entitystore/iterate/EntitiesWithCertainLinkIterable$LinksIterator;", "Ljetbrains/exodus/entitystore/iterate/LinksIteratorWithTarget;", "txn", "Ljetbrains/exodus/entitystore/PersistentStoreTransaction;", "reverse", "", "(Ljetbrains/exodus/entitystore/iterate/EntitiesWithCertainLinkIterable;Ljetbrains/exodus/entitystore/PersistentStoreTransaction;Z)V", "key", "Ljetbrains/exodus/entitystore/tables/PropertyKey;", "<set-?>", "Ljetbrains/exodus/entitystore/EntityId;", "targetId", "getTargetId", "()Ljetbrains/exodus/entitystore/EntityId;", "setTargetId", "(Ljetbrains/exodus/entitystore/EntityId;)V", "hasNextImpl", "loadCursorState", "", "nextIdImpl", "xodus-entity-store"})
    private final class LinksIterator
    extends LinksIteratorWithTarget {
        private PropertyKey key;
        @NotNull
        private EntityId targetId;
        private final boolean reverse;
        final /* synthetic */ EntitiesWithCertainLinkIterable this$0;

        @Override
        @NotNull
        public EntityId getTargetId() {
            EntityId entityId = this.targetId;
            if (entityId == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"targetId");
            }
            return entityId;
        }

        private void setTargetId(EntityId entityId) {
            this.targetId = entityId;
        }

        @Override
        public boolean hasNextImpl() {
            boolean bl;
            PropertyKey propertyKey = this.key;
            if (propertyKey != null) {
                PropertyKey propertyKey2;
                PropertyKey it = propertyKey2 = propertyKey;
                return true;
            }
            if (this.reverse) {
                Cursor cursor = this.getCursor();
                Intrinsics.checkExpressionValueIsNotNull((Object)cursor, (String)"cursor");
                bl = cursor.getPrev();
            } else {
                Cursor cursor = this.getCursor();
                Intrinsics.checkExpressionValueIsNotNull((Object)cursor, (String)"cursor");
                bl = cursor.getNext();
            }
            if (bl) {
                this.loadCursorState();
            }
            return this.key != null;
        }

        @Override
        @Nullable
        public EntityId nextIdImpl() {
            PropertyKey propertyKey = this.key;
            if (propertyKey != null) {
                PropertyKey propertyKey2;
                PropertyKey it = propertyKey2 = propertyKey;
                PersistentEntityId result = new PersistentEntityId(this.this$0.entityTypeId, it.getEntityLocalId());
                this.key = null;
                return result;
            }
            return null;
        }

        private final void loadCursorState() {
            LinkValue link;
            Cursor cursor;
            Cursor cursor2 = cursor = this.getCursor();
            Intrinsics.checkExpressionValueIsNotNull((Object)cursor2, (String)"cursor");
            LinkValue linkValue = link = LinkValue.entryToLinkValue(cursor2.getKey());
            Intrinsics.checkExpressionValueIsNotNull((Object)linkValue, (String)"link");
            if (linkValue.getLinkId() == this.this$0.getLinkId$xodus_entity_store()) {
                this.key = PropertyKey.entryToPropertyKey(cursor.getValue());
                EntityId entityId = link.getEntityId();
                Intrinsics.checkExpressionValueIsNotNull((Object)entityId, (String)"link.entityId");
                this.setTargetId(entityId);
            }
        }

        public LinksIterator(@NotNull EntitiesWithCertainLinkIterable $outer, PersistentStoreTransaction txn, boolean reverse) {
            Cursor cursor;
            Intrinsics.checkParameterIsNotNull((Object)txn, (String)"txn");
            this.this$0 = $outer;
            super($outer);
            this.reverse = reverse;
            Cursor it = cursor = $outer.openCursor(txn);
            this.setCursor(it);
            Cursor index2 = cursor;
            PersistentEntityId idBound = new PersistentEntityId(0, 0L);
            if (this.reverse) {
                boolean bl;
                if (index2.getSearchKeyRange((ByteIterable)LinkValue.linkValueToEntry(new LinkValue(idBound, $outer.getLinkId$xodus_entity_store() + 1))) == null) {
                    Cursor cursor2 = index2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)cursor2, (String)"index");
                    bl = cursor2.getLast();
                } else {
                    Cursor cursor3 = index2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)cursor3, (String)"index");
                    bl = cursor3.getPrev();
                }
                if (bl) {
                    this.loadCursorState();
                }
            } else if (index2.getSearchKeyRange((ByteIterable)LinkValue.linkValueToEntry(new LinkValue(idBound, $outer.getLinkId$xodus_entity_store()))) != null) {
                this.loadCursorState();
            }
        }

        public /* synthetic */ LinksIterator(EntitiesWithCertainLinkIterable entitiesWithCertainLinkIterable, PersistentStoreTransaction persistentStoreTransaction, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = false;
            }
            this(entitiesWithCertainLinkIterable, persistentStoreTransaction, bl);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B5\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u0010"}, d2={"Ljetbrains/exodus/entitystore/iterate/EntitiesWithCertainLinkIterable$CachedLinksIterable;", "Ljetbrains/exodus/entitystore/iterate/cached/SingleTypeUnsortedEntityIdArrayCachedInstanceIterable;", "txn", "Ljetbrains/exodus/entitystore/PersistentStoreTransaction;", "localIds", "", "targets", "", "Ljetbrains/exodus/entitystore/EntityId;", "min", "", "max", "(Ljetbrains/exodus/entitystore/iterate/EntitiesWithCertainLinkIterable;Ljetbrains/exodus/entitystore/PersistentStoreTransaction;[J[Ljetbrains/exodus/entitystore/EntityId;JJ)V", "[Ljetbrains/exodus/entitystore/EntityId;", "getIteratorImpl", "Ljetbrains/exodus/entitystore/iterate/LinksIteratorWithTarget;", "xodus-entity-store"})
    private final class CachedLinksIterable
    extends SingleTypeUnsortedEntityIdArrayCachedInstanceIterable {
        private final long[] localIds;
        private final EntityId[] targets;

        @Override
        @NotNull
        public LinksIteratorWithTarget getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
            Intrinsics.checkParameterIsNotNull((Object)txn, (String)"txn");
            return new LinksIteratorWithTarget(this, this){
                private int i;
                @NotNull
                private EntityId targetId;
                final /* synthetic */ CachedLinksIterable this$0;

                @NotNull
                public EntityId getTargetId() {
                    EntityId entityId = this.targetId;
                    if (entityId == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"targetId");
                    }
                    return entityId;
                }

                private void setTargetId(EntityId entityId) {
                    this.targetId = entityId;
                }

                protected boolean hasNextImpl() {
                    return this.i < CachedLinksIterable.access$getLocalIds$p(this.this$0).length;
                }

                @Nullable
                protected EntityId nextIdImpl() {
                    this.setTargetId(CachedLinksIterable.access$getTargets$p(this.this$0)[this.i]);
                    int n = this.i;
                    this.i = n + 1;
                    return new PersistentEntityId(this.this$0.getEntityTypeId(), CachedLinksIterable.access$getLocalIds$p(this.this$0)[n]);
                }
                {
                    this.this$0 = $outer;
                    super($super_call_param$1);
                }
            };
        }

        public CachedLinksIterable(@NotNull PersistentStoreTransaction txn, @NotNull long[] localIds, EntityId[] targets, long min, long max) {
            Intrinsics.checkParameterIsNotNull((Object)txn, (String)"txn");
            Intrinsics.checkParameterIsNotNull((Object)localIds, (String)"localIds");
            Intrinsics.checkParameterIsNotNull((Object)targets, (String)"targets");
            super(txn, EntitiesWithCertainLinkIterable.this, EntitiesWithCertainLinkIterable.this.entityTypeId, localIds, null, min, max);
            this.localIds = localIds;
            this.targets = targets;
        }

        @NotNull
        public static final /* synthetic */ long[] access$getLocalIds$p(CachedLinksIterable $this) {
            return $this.localIds;
        }

        @NotNull
        public static final /* synthetic */ EntityId[] access$getTargets$p(CachedLinksIterable $this) {
            return $this.targets;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Ljetbrains/exodus/entitystore/iterate/EntitiesWithCertainLinkIterable$Companion;", "", "()V", "type", "Ljetbrains/exodus/entitystore/EntityIterableType;", "getType", "()Ljetbrains/exodus/entitystore/EntityIterableType;", "xodus-entity-store"})
    public static final class Companion {
        @NotNull
        public final EntityIterableType getType() {
            return EntityIterableType.ENTITIES_WITH_CERTAIN_LINK;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

