/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore;

import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.bindings.StringBinding;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.Transaction;
import jetbrains.exodus.env.TransactionalExecutable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Settings {
    private Settings() {
    }

    @Nullable
    public static String get(final @NotNull Store settingsStore, final @NotNull String name) {
        final ByteIterable[] result = new ByteIterable[1];
        try {
            settingsStore.getEnvironment().executeInReadonlyTransaction(new TransactionalExecutable(){

                public void execute(@NotNull Transaction txn) {
                    result[0] = settingsStore.get(txn, (ByteIterable)StringBinding.stringToEntry((String)name));
                }
            });
        }
        catch (ExodusException exodusException) {
            // empty catch block
        }
        if (result[0] == null) {
            return null;
        }
        return StringBinding.entryToString((ByteIterable)result[0]);
    }

    public static void set(final @NotNull Store settingsStore, final @NotNull String name, final @NotNull String setting) {
        settingsStore.getEnvironment().executeInTransaction(new TransactionalExecutable(){

            public void execute(@NotNull Transaction txn) {
                settingsStore.put(txn, (ByteIterable)StringBinding.stringToEntry((String)name), (ByteIterable)StringBinding.stringToEntry((String)setting));
            }
        });
    }

    public static void delete(final @NotNull Store settingsStore, final @NotNull String name) {
        settingsStore.getEnvironment().executeInTransaction(new TransactionalExecutable(){

            public void execute(@NotNull Transaction txn) {
                settingsStore.delete(txn, (ByteIterable)StringBinding.stringToEntry((String)name));
            }
        });
    }
}

