/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore;

import java.lang.ref.SoftReference;
import jetbrains.exodus.core.dataStructures.hash.HashMap;
import jetbrains.exodus.core.dataStructures.hash.ObjectProcedure;
import jetbrains.exodus.core.dataStructures.persistent.EvictListener;
import jetbrains.exodus.core.dataStructures.persistent.PersistentObjectCache;
import jetbrains.exodus.core.execution.SharedTimer;
import jetbrains.exodus.entitystore.EntityIterableCache;
import jetbrains.exodus.entitystore.EntityIterableCacheAdapterMutable;
import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.PersistentEntityStoreConfig;
import jetbrains.exodus.entitystore.Updatable;
import jetbrains.exodus.entitystore.iterate.CachedInstanceIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class EntityIterableCacheAdapter {
    @NotNull
    protected final PersistentEntityStoreConfig config;
    @NotNull
    protected final NonAdjustablePersistentObjectCache<EntityIterableHandle, CacheItem> cache;
    @NotNull
    protected final HashMap<EntityIterableHandle, Updatable> stickyObjects;

    EntityIterableCacheAdapter(@NotNull PersistentEntityStoreConfig config) {
        this(config, new NonAdjustablePersistentObjectCache<EntityIterableHandle, CacheItem>(config.getEntityIterableCacheSize()), (HashMap<EntityIterableHandle, Updatable>)new HashMap());
    }

    EntityIterableCacheAdapter(@NotNull PersistentEntityStoreConfig config, @NotNull NonAdjustablePersistentObjectCache<EntityIterableHandle, CacheItem> cache, @NotNull HashMap<EntityIterableHandle, Updatable> stickyObjects) {
        this.config = config;
        this.cache = cache;
        this.stickyObjects = stickyObjects;
    }

    @NotNull
    public PersistentObjectCache<EntityIterableHandle, CacheItem> getCacheInstance() {
        return this.cache;
    }

    @Nullable
    CachedInstanceIterable tryKey(@NotNull EntityIterableHandle key) {
        if (key.isSticky()) {
            return (CachedInstanceIterable)((Object)this.getStickyObject(key));
        }
        CachedInstanceIterable cached = this.parseCachedObject(key, (CacheItem)this.cache.tryKey(key));
        if (cached == null) {
            cached = (CachedInstanceIterable)((Object)this.getStickyObjectUnsafe(key));
        }
        return cached;
    }

    @Nullable
    CachedInstanceIterable getObject(@NotNull EntityIterableHandle key) {
        if (key.isSticky()) {
            return (CachedInstanceIterable)((Object)this.getStickyObject(key));
        }
        CachedInstanceIterable cached = this.parseCachedObject(key, (CacheItem)this.cache.getObject(key));
        if (cached == null) {
            cached = (CachedInstanceIterable)((Object)this.getStickyObjectUnsafe(key));
        }
        return cached;
    }

    @Nullable
    Updatable getUpdatable(@NotNull EntityIterableHandle key) {
        if (key.isSticky()) {
            return this.getStickyObject(key);
        }
        Updatable updatable = (Updatable)((Object)this.parseCachedObject(key, (CacheItem)this.cache.getObject(key)));
        if (updatable == null) {
            updatable = this.getStickyObjectUnsafe(key);
        }
        return updatable;
    }

    void cacheObject(@NotNull EntityIterableHandle key, @NotNull CachedInstanceIterable it) {
        this.cache.cacheObject(key, new CacheItem(it, this.config.getEntityIterableCacheMaxSizeOfDirectValue()));
    }

    void forEachKey(ObjectProcedure<EntityIterableHandle> procedure) {
        this.cache.forEachKey(procedure);
    }

    void remove(@NotNull EntityIterableHandle key) {
        this.cache.remove(key);
    }

    float hitRate() {
        return this.cache.hitRate();
    }

    int count() {
        return this.cache.count();
    }

    int size() {
        return this.cache.size();
    }

    void clear() {
        this.cache.clear();
    }

    boolean isSparse() {
        return this.cache.count() < this.cache.size() / 2;
    }

    EntityIterableCacheAdapterMutable getClone() {
        return EntityIterableCacheAdapterMutable.create(this);
    }

    void adjustHitRate() {
        this.cache.adjustHitRate();
    }

    @Nullable
    Updatable getStickyObjectUnsafe(@NotNull EntityIterableHandle handle) {
        return (Updatable)this.stickyObjects.get((Object)handle);
    }

    @NotNull
    Updatable getStickyObject(@NotNull EntityIterableHandle handle) {
        Updatable result = this.getStickyObjectUnsafe(handle);
        if (result == null) {
            throw new IllegalStateException("Sticky object not found, handle: " + EntityIterableCache.getStringPresentation(this.config, handle));
        }
        return result;
    }

    private CachedInstanceIterable parseCachedObject(@NotNull EntityIterableHandle key, @Nullable CacheItem item) {
        if (item == null) {
            return null;
        }
        CachedInstanceIterable cached = item.cached;
        if (cached == null && (cached = (CachedInstanceIterable)item.ref.get()) == null) {
            this.cache.remove(key);
        }
        return cached;
    }

    static CachedInstanceIterable getCachedValue(@NotNull CacheItem item) {
        CachedInstanceIterable cached = item.cached;
        if (cached == null) {
            cached = (CachedInstanceIterable)item.ref.get();
        }
        return cached;
    }

    static class NonAdjustablePersistentObjectCache<K, V>
    extends PersistentObjectCache<K, V> {
        private NonAdjustablePersistentObjectCache(int size) {
            super(size);
        }

        private NonAdjustablePersistentObjectCache(@NotNull NonAdjustablePersistentObjectCache<K, V> source, @Nullable EvictListener<K, V> listener) {
            super(source, listener);
        }

        public NonAdjustablePersistentObjectCache<K, V> getClone(EvictListener<K, V> listener) {
            return new NonAdjustablePersistentObjectCache<K, V>(this, listener);
        }

        NonAdjustablePersistentObjectCache<K, V> endWrite() {
            return new NonAdjustablePersistentObjectCache<K, V>(this, null);
        }

        @Nullable
        protected SharedTimer.ExpirablePeriodicTask getCacheAdjuster() {
            return null;
        }
    }

    static final class CacheItem {
        private final CachedInstanceIterable cached;
        private final SoftReference<CachedInstanceIterable> ref;

        private CacheItem(@NotNull CachedInstanceIterable it, int maxSizeOfDirectValue) {
            if (it.isUpdatable() || it.size() <= (long)maxSizeOfDirectValue) {
                this.cached = it;
                this.ref = null;
            } else {
                this.cached = null;
                this.ref = new SoftReference<CachedInstanceIterable>(it);
            }
        }
    }
}

