/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore;

import java.lang.ref.WeakReference;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.core.dataStructures.ConcurrentObjectCache;
import jetbrains.exodus.core.dataStructures.ObjectCacheBase;
import jetbrains.exodus.core.dataStructures.Priority;
import jetbrains.exodus.core.execution.Job;
import jetbrains.exodus.core.execution.JobProcessor;
import jetbrains.exodus.core.execution.SharedTimer;
import jetbrains.exodus.entitystore.EntityIterableCacheAdapter;
import jetbrains.exodus.entitystore.EntityIterableCacheStatistics;
import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.EntityStoreSharedAsyncProcessor;
import jetbrains.exodus.entitystore.PersistentEntityStoreConfig;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.QueryCancellingPolicy;
import jetbrains.exodus.entitystore.StoreTransaction;
import jetbrains.exodus.entitystore.StoreTransactionalExecutable;
import jetbrains.exodus.entitystore.iterate.CachedInstanceIterable;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.env.ReadonlyTransactionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EntityIterableCache {
    private static final Logger logger = LoggerFactory.getLogger(EntityIterableCache.class);
    @NotNull
    private final PersistentEntityStoreImpl store;
    @NotNull
    private final PersistentEntityStoreConfig config;
    @NotNull
    private EntityIterableCacheAdapter cacheAdapter;
    @NotNull
    private final EntityIterableCacheStatistics stats;
    @NotNull
    private ObjectCacheBase<Object, Long> deferredIterablesCache;
    @NotNull
    private ObjectCacheBase<Object, Long> iterableCountsCache;
    @NotNull
    private final ObjectCacheBase<Object, Long> heavyIterablesCache;
    @NotNull
    final EntityStoreSharedAsyncProcessor processor;
    public boolean isCachingDisabled;

    EntityIterableCache(@NotNull PersistentEntityStoreImpl store) {
        this.store = store;
        this.config = store.getConfig();
        this.cacheAdapter = new EntityIterableCacheAdapter(this.config);
        this.stats = new EntityIterableCacheStatistics();
        int cacheSize = this.config.getEntityIterableCacheSize();
        this.deferredIterablesCache = new ConcurrentObjectCache(cacheSize);
        this.iterableCountsCache = new ConcurrentObjectCache(this.config.getEntityIterableCacheCountsCacheSize());
        this.heavyIterablesCache = new ConcurrentObjectCache(this.config.getEntityIterableCacheHeavyIterablesCacheSize());
        this.processor = new EntityStoreSharedAsyncProcessor(this.config.getEntityIterableCacheThreadCount());
        this.processor.start();
        this.isCachingDisabled = this.config.isCachingDisabled();
        SharedTimer.registerPeriodicTask((SharedTimer.ExpirablePeriodicTask)new CacheHitRateAdjuster(this));
    }

    public float hitRate() {
        return this.cacheAdapter.hitRate();
    }

    public float countsCacheHitRate() {
        return this.iterableCountsCache.hitRate();
    }

    @NotNull
    public EntityIterableCacheStatistics getStats() {
        return this.stats;
    }

    public int count() {
        return this.cacheAdapter.count();
    }

    public void clear() {
        this.cacheAdapter.clear();
        int cacheSize = this.config.getEntityIterableCacheSize();
        this.deferredIterablesCache = new ConcurrentObjectCache(cacheSize);
        this.iterableCountsCache = new ConcurrentObjectCache(this.config.getEntityIterableCacheCountsCacheSize());
    }

    public EntityIterableBase putIfNotCached(@NotNull EntityIterableBase it) {
        if (this.isCachingDisabled || !it.canBeCached()) {
            return it;
        }
        EntityIterableHandle handle = it.getHandle();
        PersistentStoreTransaction txn = it.getTransaction();
        EntityIterableCacheAdapter localCache = txn.getLocalCache();
        txn.localCacheAttempt();
        CachedInstanceIterable cached = localCache.tryKey(handle);
        if (cached != null) {
            if (!cached.getHandle().isExpired()) {
                txn.localCacheHit();
                this.stats.incTotalHits();
                return cached;
            }
            localCache.remove(handle);
        }
        this.stats.incTotalMisses();
        if (txn.isMutable() || !txn.isCurrent() || !txn.isCachingRelevant()) {
            return it;
        }
        if (!localCache.isSparse()) {
            long currentMillis = System.currentTimeMillis();
            Object handleIdentity = handle.getIdentity();
            Long whenCached = (Long)this.deferredIterablesCache.tryKey(handleIdentity);
            if (whenCached == null) {
                this.deferredIterablesCache.cacheObject(handleIdentity, (Object)currentMillis);
                return it;
            }
            if (whenCached + (long)this.config.getEntityIterableCacheDeferredDelay() > currentMillis) {
                return it;
            }
        }
        if (this.isDispatcherThread()) {
            return it.getOrCreateCachedInstance(txn);
        }
        new EntityIterableAsyncInstantiation(handle, it, true);
        return it;
    }

    @Nullable
    public Long getCachedCount(@NotNull EntityIterableHandle handle) {
        Long result = (Long)this.iterableCountsCache.tryKey(handle.getIdentity());
        if (result == null) {
            this.stats.incTotalCountMisses();
        } else {
            this.stats.incTotalCountHits();
        }
        return result;
    }

    public long getCachedCount(@NotNull EntityIterableBase it) {
        EntityIterableHandle handle = it.getHandle();
        Long result = this.getCachedCount(handle);
        if (result == null && this.isDispatcherThread()) {
            return it.getOrCreateCachedInstance(it.getTransaction()).size();
        }
        if (it.isThreadSafe()) {
            new EntityIterableAsyncInstantiation(handle, it, false);
        }
        return result == null ? -1L : result;
    }

    public void setCachedCount(@NotNull EntityIterableHandle handle, long count) {
        this.iterableCountsCache.cacheObject(handle.getIdentity(), (Object)count);
    }

    public boolean isDispatcherThread() {
        return this.processor.isDispatcherThread();
    }

    boolean isCachingQueueFull() {
        return this.processor.pendingJobs() > this.cacheAdapter.size();
    }

    @NotNull
    EntityIterableCacheAdapter getCacheAdapter() {
        return this.cacheAdapter;
    }

    boolean compareAndSetCacheAdapter(@NotNull EntityIterableCacheAdapter oldValue, @NotNull EntityIterableCacheAdapter newValue) {
        if (this.cacheAdapter == oldValue) {
            this.cacheAdapter = newValue;
            return true;
        }
        return false;
    }

    public static String getStringPresentation(@NotNull PersistentEntityStoreConfig config, @NotNull EntityIterableHandle handle) {
        return config.getEntityIterableCacheUseHumanReadable() ? EntityIterableBase.getHumanReadablePresentation(handle) : handle.toString();
    }

    private final class CachingCancellingPolicy
    implements QueryCancellingPolicy {
        private final boolean isConsistent;
        private final long startTime;
        private final long cachingTimeout;
        private final long startCachingTimeout;
        private EntityIterableCacheAdapter localCache;

        private CachingCancellingPolicy(boolean isConsistent) {
            this.isConsistent = isConsistent;
            this.startTime = System.currentTimeMillis();
            this.cachingTimeout = isConsistent ? EntityIterableCache.this.config.getEntityIterableCacheCachingTimeout() : EntityIterableCache.this.config.getEntityIterableCacheCountsCachingTimeout();
            this.startCachingTimeout = EntityIterableCache.this.config.getEntityIterableCacheStartCachingTimeout();
        }

        private boolean canStartAt(long currentMillis) {
            return currentMillis - this.startTime < this.startCachingTimeout;
        }

        private void setLocalCache(@NotNull EntityIterableCacheAdapter localCache) {
            this.localCache = localCache;
        }

        public boolean needToCancel() {
            return this.isConsistent && EntityIterableCache.this.cacheAdapter != this.localCache || System.currentTimeMillis() - this.startTime > this.cachingTimeout;
        }

        public void doCancel() {
            TooLongEntityIterableInstantiationReason reason = this.isConsistent && EntityIterableCache.this.cacheAdapter != this.localCache ? TooLongEntityIterableInstantiationReason.CACHE_ADAPTER_OBSOLETE : TooLongEntityIterableInstantiationReason.JOB_OVERDUE;
            throw new TooLongEntityIterableInstantiationException(reason);
        }
    }

    private static class CacheHitRateAdjuster
    implements SharedTimer.ExpirablePeriodicTask {
        @NotNull
        private final WeakReference<EntityIterableCache> cacheRef;

        private CacheHitRateAdjuster(@NotNull EntityIterableCache cache) {
            this.cacheRef = new WeakReference<EntityIterableCache>(cache);
        }

        public boolean isExpired() {
            return this.cacheRef.get() == null;
        }

        public void run() {
            EntityIterableCache cache = (EntityIterableCache)this.cacheRef.get();
            if (cache != null) {
                cache.cacheAdapter.adjustHitRate();
            }
        }
    }

    private static enum TooLongEntityIterableInstantiationReason {
        CACHE_ADAPTER_OBSOLETE("cache adapter is obsolete"),
        JOB_OVERDUE("caching job is overdue");

        private final String message;

        private TooLongEntityIterableInstantiationReason(String message) {
            this.message = message;
        }
    }

    private static class TooLongEntityIterableInstantiationException
    extends ExodusException {
        private final TooLongEntityIterableInstantiationReason reason;

        TooLongEntityIterableInstantiationException(TooLongEntityIterableInstantiationReason reason) {
            super(reason.message);
            this.reason = reason;
        }
    }

    private final class EntityIterableAsyncInstantiation
    extends Job {
        @NotNull
        private final EntityIterableBase it;
        @NotNull
        private final EntityIterableHandle handle;
        private final boolean isConsistent;
        @NotNull
        private final CachingCancellingPolicy cancellingPolicy;

        private EntityIterableAsyncInstantiation(@NotNull EntityIterableHandle handle, EntityIterableBase it, boolean isConsistent) {
            this.it = it;
            this.handle = handle;
            this.isConsistent = isConsistent;
            this.cancellingPolicy = new CachingCancellingPolicy(isConsistent && handle.isConsistent());
            this.setProcessor((JobProcessor)EntityIterableCache.this.processor);
            if (!EntityIterableCache.this.isCachingQueueFull() && this.queue(Priority.normal)) {
                EntityIterableCache.this.stats.incTotalJobsEnqueued();
                if (!isConsistent) {
                    EntityIterableCache.this.stats.incTotalCountJobsEnqueued();
                }
            } else {
                EntityIterableCache.this.stats.incTotalJobsNonQueued();
            }
        }

        public String getName() {
            return "Caching job for handle " + this.it.getHandle();
        }

        public String getGroup() {
            return EntityIterableCache.this.store.getLocation();
        }

        public boolean isEqualTo(Job job) {
            return this.handle.equals(((EntityIterableAsyncInstantiation)job).handle);
        }

        public int hashCode() {
            int hc = this.handle.hashCode() & 0xFFFEFFFE;
            return this.isConsistent ? hc : hc | 1;
        }

        protected void execute() {
            Long lastCancelled;
            long started;
            if (EntityIterableCache.this.isCachingQueueFull() || !this.cancellingPolicy.canStartAt(started = System.currentTimeMillis())) {
                EntityIterableCache.this.stats.incTotalJobsNotStarted();
                return;
            }
            final Object iterableIdentity = this.handle.getIdentity();
            if (this.isConsistent && (lastCancelled = (Long)EntityIterableCache.this.heavyIterablesCache.tryKey(iterableIdentity)) != null) {
                if (lastCancelled + EntityIterableCache.this.config.getEntityIterableCacheHeavyIterablesLifeSpan() > started) {
                    EntityIterableCache.this.stats.incTotalJobsNotStarted();
                    if (logger.isInfoEnabled()) {
                        logger.info("Heavy iterable not started, handle=" + EntityIterableCache.getStringPresentation(EntityIterableCache.this.config, this.handle));
                    }
                    return;
                }
                EntityIterableCache.this.heavyIterablesCache.remove(iterableIdentity);
            }
            EntityIterableCache.this.stats.incTotalJobsStarted();
            EntityIterableCache.this.store.executeInReadonlyTransaction(new StoreTransactionalExecutable(){

                public void execute(@NotNull StoreTransaction tx) {
                    block8: {
                        if (!EntityIterableAsyncInstantiation.this.handle.isConsistent()) {
                            EntityIterableAsyncInstantiation.this.handle.resetBirthTime();
                        }
                        PersistentStoreTransaction txn = (PersistentStoreTransaction)tx;
                        EntityIterableAsyncInstantiation.this.cancellingPolicy.setLocalCache(txn.getLocalCache());
                        txn.setQueryCancellingPolicy(EntityIterableAsyncInstantiation.this.cancellingPolicy);
                        try {
                            if (!logger.isInfoEnabled()) {
                                EntityIterableAsyncInstantiation.this.it.getOrCreateCachedInstance(txn, !EntityIterableAsyncInstantiation.this.cancellingPolicy.isConsistent);
                            } else {
                                EntityIterableAsyncInstantiation.this.it.getOrCreateCachedInstance(txn, !EntityIterableAsyncInstantiation.this.cancellingPolicy.isConsistent);
                                long cachedIn = System.currentTimeMillis() - started;
                                if (cachedIn > 1000L) {
                                    String action = EntityIterableAsyncInstantiation.this.cancellingPolicy.isConsistent ? "Cached" : "Cached (inconsistent)";
                                    logger.info(action + " in " + cachedIn + " ms, handle=" + EntityIterableCache.getStringPresentation(EntityIterableCache.this.config, EntityIterableAsyncInstantiation.this.handle));
                                }
                            }
                        }
                        catch (ReadonlyTransactionException rte) {
                            String action = EntityIterableAsyncInstantiation.this.cancellingPolicy.isConsistent ? "Caching" : "Caching (inconsistent)";
                            logger.error(action + " failed with ReadonlyTransactionException. Re-queueing...");
                            EntityIterableAsyncInstantiation.this.queue(Priority.below_normal);
                        }
                        catch (TooLongEntityIterableInstantiationException e) {
                            EntityIterableCache.this.stats.incTotalJobsInterrupted();
                            if (EntityIterableAsyncInstantiation.this.isConsistent) {
                                EntityIterableCache.this.heavyIterablesCache.cacheObject(iterableIdentity, (Object)System.currentTimeMillis());
                            }
                            if (!logger.isInfoEnabled()) break block8;
                            String action = EntityIterableAsyncInstantiation.this.cancellingPolicy.isConsistent ? "Caching" : "Caching (inconsistent)";
                            logger.info(action + " forcedly stopped, " + e.reason.message + ": " + EntityIterableCache.getStringPresentation(EntityIterableCache.this.config, EntityIterableAsyncInstantiation.this.handle));
                        }
                    }
                }
            });
        }
    }
}

