/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.base.spatial;

import java.util.HashSet;
import java.util.Set;
import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.base.math.MathKt;
import jetbrains.datalore.base.typedGeometry.FunctionsKt;
import jetbrains.datalore.base.typedGeometry.Rect;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u001aP\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0003\"\u0004\b\u0001\u0010\u00022\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00030\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00030\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u0002H\u00020\n\u001a\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b\u001a\u001e\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u0010"}, d2={"calculateQuadKeys", "", "QuadT", "GeometryT", "mapRect", "Ljetbrains/datalore/base/typedGeometry/Rect;", "viewRect", "zoom", "", "quadKeyFactory", "Lkotlin/Function1;", "", "calulateQuadsCount", "xyToKey", "x", "y", "base-portable"})
public final class QuadsKt {
    public static final int calulateQuadsCount(int zoom) {
        return (int)MathKt.ipow(2, zoom);
    }

    @NotNull
    public static final <GeometryT, QuadT> Set<QuadT> calculateQuadKeys(@NotNull Rect<GeometryT> mapRect, @NotNull Rect<GeometryT> viewRect, int zoom, @NotNull Function1<? super String, ? extends QuadT> quadKeyFactory) {
        Intrinsics.checkNotNullParameter(mapRect, (String)"mapRect");
        Intrinsics.checkNotNullParameter(viewRect, (String)"viewRect");
        Intrinsics.checkNotNullParameter(quadKeyFactory, (String)"quadKeyFactory");
        HashSet<Object> quadKeys = new HashSet<Object>();
        int tileCount = QuadsKt.calulateQuadsCount(zoom);
        int xmin = QuadsKt.calculateQuadKeys$calcQuadNum(FunctionsKt.getLeft(viewRect), FunctionsKt.xRange(mapRect), tileCount);
        int xmax = QuadsKt.calculateQuadKeys$calcQuadNum(FunctionsKt.getRight(viewRect), FunctionsKt.xRange(mapRect), tileCount);
        int ymin = QuadsKt.calculateQuadKeys$calcQuadNum(FunctionsKt.getTop(viewRect), FunctionsKt.yRange(mapRect), tileCount);
        int ymax = QuadsKt.calculateQuadKeys$calcQuadNum(FunctionsKt.getBottom(viewRect), FunctionsKt.yRange(mapRect), tileCount);
        int n = xmin;
        if (n <= xmax) {
            int x2;
            do {
                int y2;
                x2 = n++;
                int n2 = ymin;
                if (n2 > ymax) continue;
                do {
                    y2 = n2++;
                    Object object = QuadsKt.xyToKey(x2, y2, zoom);
                    boolean bl = false;
                    boolean bl2 = false;
                    object = quadKeyFactory.invoke(object);
                    bl = false;
                    bl2 = false;
                    Object p0 = object;
                    boolean bl3 = false;
                    quadKeys.add(p0);
                } while (y2 != ymax);
            } while (x2 != xmax);
        }
        return quadKeys;
    }

    @NotNull
    public static final String xyToKey(int x2, int y2, int zoom) {
        String key = "";
        int n = zoom;
        if (1 <= n) {
            do {
                int i = n--;
                char digit = '0';
                int mask = 1 << i - 1;
                if ((x2 & mask) != 0) {
                    digit = (char)(digit + 1);
                }
                if ((y2 & mask) != 0) {
                    digit = (char)(digit + 2);
                }
                key = Intrinsics.stringPlus((String)key, (Object)Character.valueOf(digit));
            } while (1 <= n);
        }
        return key;
    }

    private static final int calculateQuadKeys$calcQuadNum(double value, ClosedRange<Double> range, int tileCount) {
        double position = (value - ((Number)range.getLowerEnd()).doubleValue()) / (((Number)range.getUpperEnd()).doubleValue() - ((Number)range.getLowerEnd()).doubleValue());
        double d = 0.0;
        double d2 = position * (double)tileCount;
        double d3 = tileCount - 1;
        boolean bl = false;
        d2 = Math.min(d2, d3);
        boolean bl2 = false;
        return (int)Math.max(d, d2);
    }
}

