/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.base.spatial;

import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.base.math.MathKt;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004J\u000e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0004J\u000e\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004J\u000e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004J\u000e\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004J\u000e\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004J\u0010\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0018"}, d2={"Ljetbrains/datalore/base/spatial/MercatorUtils;", "", "()V", "MAX_LATITUDE", "", "MAX_LONGITUDE", "VALID_LATITUDE_RANGE", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "getVALID_LATITUDE_RANGE", "()Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "VALID_LONGITUDE_RANGE", "getVALID_LONGITUDE_RANGE", "checkLat", "", "lat", "checkLon", "lon", "getLatitude", "y", "getLongitude", "x", "getMercatorX", "getMercatorY", "normalizeLat", "base-portable"})
public final class MercatorUtils {
    @NotNull
    public static final MercatorUtils INSTANCE = new MercatorUtils();
    private static final double MAX_LONGITUDE = 180.0;
    private static final double MAX_LATITUDE = 85.0511287798;
    @NotNull
    private static final ClosedRange<Double> VALID_LONGITUDE_RANGE = new ClosedRange<Comparable>(Double.valueOf(-180.0), Double.valueOf(180.0));
    @NotNull
    private static final ClosedRange<Double> VALID_LATITUDE_RANGE = new ClosedRange<Comparable>(Double.valueOf(-85.0511287798), Double.valueOf(85.0511287798));

    private MercatorUtils() {
    }

    @NotNull
    public final ClosedRange<Double> getVALID_LONGITUDE_RANGE() {
        return VALID_LONGITUDE_RANGE;
    }

    @NotNull
    public final ClosedRange<Double> getVALID_LATITUDE_RANGE() {
        return VALID_LATITUDE_RANGE;
    }

    public final double getMercatorX(double lon) {
        return MathKt.toRadians(lon) * 6378137.0;
    }

    public final double getMercatorY(double lat) {
        double lat2 = this.normalizeLat(lat);
        double d = 0.7853981633974483 + MathKt.toRadians(lat2) / (double)2;
        boolean bl = false;
        d = Math.tan(d);
        bl = false;
        return Math.log(d) * 6378137.0;
    }

    public final double getLongitude(double x2) {
        return MathKt.toDegrees(x2 / 6378137.0);
    }

    public final double getLatitude(double y2) {
        double d = y2 / 6378137.0;
        boolean bl = false;
        d = Math.exp(d);
        bl = false;
        return this.normalizeLat(MathKt.toDegrees((Math.atan(d) - 0.7853981633974483) * (double)2));
    }

    public final boolean checkLon(double lon) {
        return VALID_LONGITUDE_RANGE.contains((Double)((Comparable)Double.valueOf(lon)));
    }

    public final boolean checkLat(double lat) {
        return VALID_LATITUDE_RANGE.contains((Double)((Comparable)Double.valueOf(lat)));
    }

    private final double normalizeLat(double lat) {
        double d = -85.0511287798;
        double d2 = 85.0511287798;
        boolean bl = false;
        d2 = Math.min(lat, d2);
        bl = false;
        return Math.max(d, d2);
    }
}

