/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.constants;

import java.util.Arrays;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.constants.IntegerValueConstant;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import org.jetbrains.annotations.NotNull;

public final class CharValue
extends IntegerValueConstant<Character> {
    public CharValue(char value) {
        super(Character.valueOf(value));
    }

    @Override
    @NotNull
    public SimpleType getType(@NotNull ModuleDescriptor module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        SimpleType simpleType2 = module.getBuiltIns().getCharType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"module.builtIns.charType");
        return simpleType2;
    }

    @Override
    @NotNull
    public String toString() {
        String string = "\\u%04X ('%s')";
        Object[] objectArray = new Object[2];
        char c = ((Character)this.getValue()).charValue();
        boolean bl = false;
        objectArray[0] = (int)c;
        objectArray[1] = this.getPrintablePart(((Character)this.getValue()).charValue());
        c = '\u0000';
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(this, *args)");
        return string2;
    }

    private final String getPrintablePart(char c) {
        char c2 = c;
        return c2 == '\b' ? "\\b" : (c2 == '\t' ? "\\t" : (c2 == '\n' ? "\\n" : (c2 == '\f' ? "\\f" : (c2 == '\r' ? "\\r" : (this.isPrintableUnicode(c) ? String.valueOf(c) : "?")))));
    }

    private final boolean isPrintableUnicode(char c) {
        byte t = (byte)Character.getType(c);
        return t != 0 && t != 13 && t != 14 && t != 15 && t != 16 && t != 18 && t != 19;
    }
}

