/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.push;

import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.Version;
import org.codehaus.jackson.util.VersionUtil;

public class ClientInfo {
    public Version version = Version.unknownVersion();
    public ClientType type = ClientType.UNKNOWN;

    public ClientInfo(String userAgent) {
        String versionStr;
        String string = versionStr = StringUtils.isEmpty((CharSequence)userAgent) ? "" : userAgent;
        if (versionStr.startsWith("Nacos-Java-Client")) {
            this.type = ClientType.JAVA;
            versionStr = versionStr.substring(versionStr.indexOf(":v") + 2, versionStr.length());
            this.version = VersionUtil.parseVersion((String)versionStr);
            return;
        }
        if (versionStr.startsWith("Nacos-DNS")) {
            this.type = ClientType.DNS;
            versionStr = versionStr.substring(versionStr.indexOf(":v") + 2, versionStr.length());
            this.version = VersionUtil.parseVersion((String)versionStr);
            return;
        }
        if (versionStr.startsWith("Nacos-C-Client")) {
            this.type = ClientType.C;
            versionStr = versionStr.substring(versionStr.indexOf(":v") + 2, versionStr.length());
            this.version = VersionUtil.parseVersion((String)versionStr);
            return;
        }
        if (versionStr.startsWith("Nacos-SDK-Java")) {
            this.type = ClientType.JAVA_SDK;
            versionStr = versionStr.substring(versionStr.indexOf(":v") + 2, versionStr.length());
            this.version = VersionUtil.parseVersion((String)versionStr);
            return;
        }
        if (versionStr.startsWith("Nacos-Server")) {
            this.type = ClientType.NACOS_SERVER;
            versionStr = versionStr.substring(versionStr.indexOf(":v") + 2, versionStr.length());
            this.version = VersionUtil.parseVersion((String)versionStr);
            return;
        }
        if (versionStr.startsWith("unit-nginx")) {
            this.type = ClientType.TENGINE;
            versionStr = versionStr.substring(versionStr.indexOf(":v") + 2, versionStr.length());
            this.version = VersionUtil.parseVersion((String)versionStr);
            return;
        }
        if (versionStr.startsWith("vip-client4cpp")) {
            this.type = ClientType.C;
            versionStr = versionStr.substring(versionStr.indexOf(":v") + 2, versionStr.length());
            this.version = VersionUtil.parseVersion((String)versionStr);
            return;
        }
        if (versionStr.startsWith("Nacos-Go-Client")) {
            this.type = ClientType.GO;
            versionStr = versionStr.substring(versionStr.indexOf(":v") + 2, versionStr.length());
            this.version = VersionUtil.parseVersion((String)versionStr);
            return;
        }
        if (versionStr.startsWith("Nacos-CSharp-Client")) {
            this.type = ClientType.CSHARP;
            versionStr = versionStr.substring(versionStr.indexOf(":v") + 2, versionStr.length());
            this.version = VersionUtil.parseVersion((String)versionStr);
            return;
        }
        this.type = ClientType.UNKNOWN;
        this.version = Version.unknownVersion();
    }

    public static class ClientTypeDescription {
        public static final String JAVA_CLIENT = "Nacos-Java-Client";
        public static final String DNSF_CLIENT = "Nacos-DNS";
        public static final String C_CLIENT = "Nacos-C-Client";
        public static final String SDK_CLIENT = "Nacos-SDK-Java";
        public static final String NGINX_CLIENT = "unit-nginx";
        public static final String CPP_CLIENT = "vip-client4cpp";
        public static final String GO_CLIENT = "Nacos-Go-Client";
        public static final String CSHARP_CLIENT = "Nacos-CSharp-Client";
    }

    public static enum ClientType {
        GO,
        JAVA,
        C,
        CSHARP,
        PHP,
        DNS,
        TENGINE,
        JAVA_SDK,
        NACOS_SERVER,
        UNKNOWN;

    }
}

