/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.misc;

import com.alibaba.nacos.common.http.Callback;
import com.alibaba.nacos.common.model.RestResult;
import com.alibaba.nacos.common.utils.IPUtil;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.VersionUtils;
import com.alibaba.nacos.naming.misc.HttpClient;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.misc.NetUtils;
import com.alibaba.nacos.naming.misc.UtilsAndCommons;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class NamingProxy {
    private static final String DATA_ON_SYNC_URL = "/distro/datum";
    private static final String DATA_GET_URL = "/distro/datum";
    private static final String ALL_DATA_GET_URL = "/distro/datums";
    private static final String TIMESTAMP_SYNC_URL = "/distro/checksum";

    public static void syncCheckSums(Map<String, String> checksumMap, String server) {
        NamingProxy.syncCheckSums(JacksonUtils.toJsonBytes(checksumMap), server);
    }

    public static void syncCheckSums(byte[] checksums, final String server) {
        try {
            HashMap<String, String> headers = new HashMap<String, String>(128);
            headers.put("Client-Version", VersionUtils.version);
            headers.put("User-Agent", UtilsAndCommons.SERVER_VERSION);
            headers.put("Connection", "Keep-Alive");
            HttpClient.asyncHttpPutLarge("http://" + server + EnvUtil.getContextPath() + "/v1/ns" + TIMESTAMP_SYNC_URL + "?source=" + NetUtils.localServer(), headers, checksums, new Callback<String>(){

                public void onReceive(RestResult<String> result) {
                    if (!result.ok()) {
                        Loggers.DISTRO.error("failed to req API: {}, code: {}, msg: {}", new Object[]{"http://" + server + EnvUtil.getContextPath() + "/v1/ns" + NamingProxy.TIMESTAMP_SYNC_URL, result.getCode(), result.getMessage()});
                    }
                }

                public void onError(Throwable throwable) {
                    Loggers.DISTRO.error("failed to req API:http://" + server + EnvUtil.getContextPath() + "/v1/ns" + NamingProxy.TIMESTAMP_SYNC_URL, throwable);
                }

                public void onCancel() {
                }
            });
        }
        catch (Exception e) {
            Loggers.DISTRO.warn("NamingProxy", (Throwable)e);
        }
    }

    public static byte[] getData(List<String> keys, String server) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("keys", StringUtils.join(keys, (String)","));
        RestResult<String> result = HttpClient.httpGetLarge("http://" + server + EnvUtil.getContextPath() + "/v1/ns" + "/distro/datum", new HashMap<String, String>(8), JacksonUtils.toJson(params));
        if (result.ok()) {
            return ((String)result.getData()).getBytes();
        }
        throw new IOException("failed to req API: http://" + server + EnvUtil.getContextPath() + "/v1/ns" + "/distro/datum" + ". code: " + result.getCode() + " msg: " + result.getMessage());
    }

    public static byte[] getAllData(String server) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>(8);
        RestResult<String> result = HttpClient.httpGet("http://" + server + EnvUtil.getContextPath() + "/v1/ns" + ALL_DATA_GET_URL, new ArrayList<String>(), params);
        if (result.ok()) {
            return ((String)result.getData()).getBytes();
        }
        throw new IOException("failed to req API: http://" + server + EnvUtil.getContextPath() + "/v1/ns" + ALL_DATA_GET_URL + ". code: " + result.getCode() + " msg: " + result.getMessage());
    }

    public static boolean syncData(byte[] data, String curServer) {
        HashMap<String, String> headers = new HashMap<String, String>(128);
        headers.put("Client-Version", VersionUtils.version);
        headers.put("User-Agent", UtilsAndCommons.SERVER_VERSION);
        headers.put("Accept-Encoding", "gzip,deflate,sdch");
        headers.put("Connection", "Keep-Alive");
        headers.put("Content-Encoding", "gzip");
        try {
            RestResult<String> result = HttpClient.httpPutLarge("http://" + curServer + EnvUtil.getContextPath() + "/v1/ns" + "/distro/datum", headers, data);
            if (result.ok()) {
                return true;
            }
            if (304 == result.getCode()) {
                return true;
            }
            throw new IOException("failed to req API:http://" + curServer + EnvUtil.getContextPath() + "/v1/ns" + "/distro/datum" + ". code:" + result.getCode() + " msg: " + (String)result.getData());
        }
        catch (Exception e) {
            Loggers.SRV_LOG.warn("NamingProxy", (Throwable)e);
            return false;
        }
    }

    public static String reqApi(String api, Map<String, String> params, String curServer) throws Exception {
        try {
            RestResult<String> result;
            List<String> headers = Arrays.asList("Client-Version", VersionUtils.version, "User-Agent", UtilsAndCommons.SERVER_VERSION, "Accept-Encoding", "gzip,deflate,sdch", "Connection", "Keep-Alive", "Content-Encoding", "gzip");
            if (!IPUtil.containsPort((String)curServer)) {
                curServer = curServer + ":" + EnvUtil.getPort();
            }
            if ((result = HttpClient.httpGet("http://" + curServer + api, headers, params)).ok()) {
                return (String)result.getData();
            }
            if (304 == result.getCode()) {
                return "";
            }
            throw new IOException("failed to req API:http://" + curServer + api + ". code:" + result.getCode() + " msg: " + result.getMessage());
        }
        catch (Exception e) {
            Loggers.SRV_LOG.warn("NamingProxy", (Throwable)e);
            return "";
        }
    }

    public static String reqApi(String api, Map<String, String> params, String curServer, boolean isPost) throws Exception {
        try {
            RestResult<String> result;
            List<String> headers = Arrays.asList("Client-Version", VersionUtils.version, "User-Agent", UtilsAndCommons.SERVER_VERSION, "Accept-Encoding", "gzip,deflate,sdch", "Connection", "Keep-Alive", "Content-Encoding", "gzip");
            if (!IPUtil.containsPort((String)curServer)) {
                curServer = curServer + ":" + EnvUtil.getPort();
            }
            if ((result = isPost ? HttpClient.httpPost("http://" + curServer + EnvUtil.getContextPath() + "/v1/ns" + "/api/" + api, headers, params) : HttpClient.httpGet("http://" + curServer + EnvUtil.getContextPath() + "/v1/ns" + "/api/" + api, headers, params)).ok()) {
                return (String)result.getData();
            }
            if (304 == result.getCode()) {
                return "";
            }
            throw new IOException("failed to req API:http://" + curServer + EnvUtil.getContextPath() + "/v1/ns" + "/api/" + api + ". code:" + result.getCode() + " msg: " + result.getMessage());
        }
        catch (Exception e) {
            Loggers.SRV_LOG.warn("NamingProxy", (Throwable)e);
            return "";
        }
    }

    public static String reqCommon(String path, Map<String, String> params, String curServer, boolean isPost) throws Exception {
        try {
            RestResult<String> result;
            List<String> headers = Arrays.asList("Client-Version", UtilsAndCommons.SERVER_VERSION, "User-Agent", UtilsAndCommons.SERVER_VERSION, "Accept-Encoding", "gzip,deflate,sdch", "Connection", "Keep-Alive", "Content-Encoding", "gzip");
            if (!IPUtil.containsPort((String)curServer)) {
                curServer = curServer + ":" + EnvUtil.getPort();
            }
            if ((result = isPost ? HttpClient.httpPost("http://" + curServer + EnvUtil.getContextPath() + "/v1/ns" + path, headers, params) : HttpClient.httpGet("http://" + curServer + EnvUtil.getContextPath() + "/v1/ns" + path, headers, params)).ok()) {
                return (String)result.getData();
            }
            if (304 == result.getCode()) {
                return "";
            }
            throw new IOException("failed to req API:http://" + curServer + EnvUtil.getContextPath() + "/v1/ns" + path + ". code:" + result.getCode() + " msg: " + result.getMessage());
        }
        catch (Exception e) {
            Loggers.SRV_LOG.warn("NamingProxy", (Throwable)e);
            return "";
        }
    }

    public static class Request {
        private Map<String, String> params = new HashMap<String, String>(8);

        public static Request newRequest() {
            return new Request();
        }

        public Request appendParam(String key, String value) {
            this.params.put(key, value);
            return this;
        }

        public String toUrl() {
            StringBuilder sb = new StringBuilder();
            for (String key : this.params.keySet()) {
                sb.append(key).append("=").append(this.params.get(key)).append("&");
            }
            return sb.toString();
        }
    }
}

