/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.misc;

import com.alibaba.nacos.core.distributed.distro.DistroConfig;
import com.alibaba.nacos.naming.misc.Loggers;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class GlobalConfig {
    private final DistroConfig distroConfig;
    @Value(value="${nacos.naming.distro.taskDispatchPeriod:2000}")
    private int taskDispatchPeriod = 2000;
    @Value(value="${nacos.naming.distro.batchSyncKeyCount:1000}")
    private int batchSyncKeyCount = 1000;
    @Value(value="${nacos.naming.distro.syncRetryDelay:5000}")
    private long syncRetryDelay = 5000L;
    @Value(value="${nacos.naming.data.warmup:false}")
    private boolean dataWarmup = false;
    @Value(value="${nacos.naming.expireInstance:true}")
    private boolean expireInstance = true;
    @Value(value="${nacos.naming.distro.loadDataRetryDelayMillis:30000}")
    private long loadDataRetryDelayMillis = 30000L;

    public GlobalConfig(DistroConfig distroConfig) {
        this.distroConfig = distroConfig;
    }

    @PostConstruct
    public void printGlobalConfig() {
        Loggers.SRV_LOG.info(this.toString());
        this.overrideDistroConfiguration();
    }

    private void overrideDistroConfiguration() {
        this.distroConfig.setSyncDelayMillis((long)this.taskDispatchPeriod);
        this.distroConfig.setSyncRetryDelayMillis(this.syncRetryDelay);
        this.distroConfig.setLoadDataRetryDelayMillis(this.loadDataRetryDelayMillis);
    }

    public int getTaskDispatchPeriod() {
        return this.taskDispatchPeriod;
    }

    public int getBatchSyncKeyCount() {
        return this.batchSyncKeyCount;
    }

    public long getSyncRetryDelay() {
        return this.syncRetryDelay;
    }

    public boolean isDataWarmup() {
        return this.dataWarmup;
    }

    public boolean isExpireInstance() {
        return this.expireInstance;
    }

    public long getLoadDataRetryDelayMillis() {
        return this.loadDataRetryDelayMillis;
    }

    public String toString() {
        return "GlobalConfig{taskDispatchPeriod=" + this.taskDispatchPeriod + ", batchSyncKeyCount=" + this.batchSyncKeyCount + ", syncRetryDelay=" + this.syncRetryDelay + ", dataWarmup=" + this.dataWarmup + ", expireInstance=" + this.expireInstance + ", loadDataRetryDelayMillis=" + this.loadDataRetryDelayMillis + '}';
    }
}

