/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.healthcheck;

import com.alibaba.nacos.naming.core.Cluster;
import com.alibaba.nacos.naming.core.Instance;
import com.alibaba.nacos.naming.healthcheck.HealthCheckCommon;
import com.alibaba.nacos.naming.healthcheck.HealthCheckProcessor;
import com.alibaba.nacos.naming.healthcheck.HealthCheckTask;
import com.alibaba.nacos.naming.misc.GlobalExecutor;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.misc.SwitchDomain;
import com.alibaba.nacos.naming.monitor.MetricsMonitor;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TcpSuperSenseProcessor
implements HealthCheckProcessor,
Runnable {
    public static final String TYPE = "TCP";
    @Autowired
    private HealthCheckCommon healthCheckCommon;
    @Autowired
    private SwitchDomain switchDomain;
    public static final int CONNECT_TIMEOUT_MS = 500;
    private Map<String, BeatKey> keyMap = new ConcurrentHashMap<String, BeatKey>();
    private BlockingQueue<Beat> taskQueue = new LinkedBlockingQueue<Beat>();
    private static final int NIO_THREAD_COUNT = Runtime.getRuntime().availableProcessors() <= 1 ? 1 : Runtime.getRuntime().availableProcessors() / 2;
    private static final long TCP_KEEP_ALIVE_MILLIS = 0L;
    private Selector selector;

    public TcpSuperSenseProcessor() {
        try {
            this.selector = Selector.open();
            GlobalExecutor.submitTcpCheck(this);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error while initializing SuperSense(TM).");
        }
    }

    @Override
    public void process(HealthCheckTask task) {
        List<Instance> ips = task.getCluster().allIPs(false);
        if (CollectionUtils.isEmpty(ips)) {
            return;
        }
        for (Instance ip : ips) {
            if (ip.isMarked()) {
                if (!Loggers.SRV_LOG.isDebugEnabled()) continue;
                Loggers.SRV_LOG.debug("tcp check, ip is marked as to skip health check, ip:" + ip.getIp());
                continue;
            }
            if (!ip.markChecking()) {
                Loggers.SRV_LOG.warn("tcp check started before last one finished, service: " + task.getCluster().getService().getName() + ":" + task.getCluster().getName() + ":" + ip.getIp() + ":" + ip.getPort());
                this.healthCheckCommon.reEvaluateCheckRT(task.getCheckRtNormalized() * 2L, task, this.switchDomain.getTcpHealthParams());
                continue;
            }
            Beat beat = new Beat(ip, task);
            this.taskQueue.add(beat);
            MetricsMonitor.getTcpHealthCheckMonitor().incrementAndGet();
        }
    }

    private void processTask() throws Exception {
        LinkedList<TaskProcessor> tasks = new LinkedList<TaskProcessor>();
        do {
            Beat beat;
            if ((beat = this.taskQueue.poll(250L, TimeUnit.MILLISECONDS)) == null) {
                return;
            }
            tasks.add(new TaskProcessor(beat));
        } while (this.taskQueue.size() > 0 && tasks.size() < NIO_THREAD_COUNT * 64);
        for (Future f : GlobalExecutor.invokeAllTcpSuperSenseTask(tasks)) {
            f.get();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        while (true) {
            try {
                block3: while (true) {
                    this.processTask();
                    readyCount = this.selector.selectNow();
                    if (readyCount <= 0) continue;
                    iter = this.selector.selectedKeys().iterator();
                    while (true) {
                        if (iter.hasNext()) ** break;
                        continue block3;
                        key = iter.next();
                        iter.remove();
                        GlobalExecutor.executeTcpSuperSense(new PostProcessor(key));
                    }
                    break;
                }
            }
            catch (Throwable e) {
                Loggers.SRV_LOG.error("[HEALTH-CHECK] error while processing NIO task", e);
                continue;
            }
            break;
        }
    }

    @Override
    public String getType() {
        return TYPE;
    }

    private class TaskProcessor
    implements Callable<Void> {
        private static final int MAX_WAIT_TIME_MILLISECONDS = 500;
        Beat beat;

        public TaskProcessor(Beat beat) {
            this.beat = beat;
        }

        @Override
        public Void call() {
            block7: {
                long waited = System.currentTimeMillis() - this.beat.getStartTime();
                if (waited > 500L) {
                    Loggers.SRV_LOG.warn("beat task waited too long: " + waited + "ms");
                }
                SocketChannel channel = null;
                try {
                    Instance instance = this.beat.getIp();
                    BeatKey beatKey = (BeatKey)TcpSuperSenseProcessor.this.keyMap.get(this.beat.toString());
                    if (beatKey != null && beatKey.key.isValid()) {
                        if (System.currentTimeMillis() - beatKey.birthTime < 0L) {
                            instance.setBeingChecked(false);
                            return null;
                        }
                        beatKey.key.cancel();
                        beatKey.key.channel().close();
                    }
                    channel = SocketChannel.open();
                    channel.configureBlocking(false);
                    channel.socket().setSoLinger(false, -1);
                    channel.socket().setReuseAddress(true);
                    channel.socket().setKeepAlive(true);
                    channel.socket().setTcpNoDelay(true);
                    Cluster cluster = this.beat.getTask().getCluster();
                    int port = cluster.isUseIPPort4Check() ? instance.getPort() : cluster.getDefCkport();
                    channel.connect(new InetSocketAddress(instance.getIp(), port));
                    SelectionKey key = channel.register(TcpSuperSenseProcessor.this.selector, 9);
                    key.attach(this.beat);
                    TcpSuperSenseProcessor.this.keyMap.put(this.beat.toString(), new BeatKey(key));
                    this.beat.setStartTime(System.currentTimeMillis());
                    GlobalExecutor.scheduleTcpSuperSenseTask(new TimeOutTask(key), 500L, TimeUnit.MILLISECONDS);
                }
                catch (Exception e) {
                    this.beat.finishCheck(false, false, TcpSuperSenseProcessor.this.switchDomain.getTcpHealthParams().getMax(), "tcp:error:" + e.getMessage());
                    if (channel == null) break block7;
                    try {
                        channel.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return null;
        }
    }

    private static class TimeOutTask
    implements Runnable {
        SelectionKey key;

        public TimeOutTask(SelectionKey key) {
            this.key = key;
        }

        @Override
        public void run() {
            if (this.key != null && this.key.isValid()) {
                SocketChannel channel = (SocketChannel)this.key.channel();
                Beat beat = (Beat)this.key.attachment();
                if (channel.isConnected()) {
                    return;
                }
                try {
                    channel.finishConnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    beat.finishCheck(false, false, beat.getTask().getCheckRtNormalized() * 2L, "tcp:timeout");
                    this.key.cancel();
                    this.key.channel().close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static class BeatKey {
        public SelectionKey key;
        public long birthTime;

        public BeatKey(SelectionKey key) {
            this.key = key;
            this.birthTime = System.currentTimeMillis();
        }
    }

    private class Beat {
        Instance ip;
        HealthCheckTask task;
        long startTime = System.currentTimeMillis();

        Beat(Instance ip, HealthCheckTask task) {
            this.ip = ip;
            this.task = task;
        }

        public void setStartTime(long time) {
            this.startTime = time;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public Instance getIp() {
            return this.ip;
        }

        public HealthCheckTask getTask() {
            return this.task;
        }

        public boolean isHealthy() {
            return System.currentTimeMillis() - this.startTime < TimeUnit.SECONDS.toMillis(30L);
        }

        public void finishCheck() {
            this.ip.setBeingChecked(false);
        }

        public void finishCheck(boolean success, boolean now, long rt, String msg) {
            this.ip.setCheckRt(System.currentTimeMillis() - this.startTime);
            if (success) {
                TcpSuperSenseProcessor.this.healthCheckCommon.checkOK(this.ip, this.task, msg);
            } else {
                if (now) {
                    TcpSuperSenseProcessor.this.healthCheckCommon.checkFailNow(this.ip, this.task, msg);
                } else {
                    TcpSuperSenseProcessor.this.healthCheckCommon.checkFail(this.ip, this.task, msg);
                }
                TcpSuperSenseProcessor.this.keyMap.remove(this.task.toString());
            }
            TcpSuperSenseProcessor.this.healthCheckCommon.reEvaluateCheckRT(rt, this.task, TcpSuperSenseProcessor.this.switchDomain.getTcpHealthParams());
        }

        public String toString() {
            return this.task.getCluster().getService().getName() + ":" + this.task.getCluster().getName() + ":" + this.ip.getIp() + ":" + this.ip.getPort();
        }

        public int hashCode() {
            return Objects.hash(this.ip.toJson());
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof Beat)) {
                return false;
            }
            return this.toString().equals(obj.toString());
        }
    }

    public class PostProcessor
    implements Runnable {
        SelectionKey key;

        public PostProcessor(SelectionKey key) {
            this.key = key;
        }

        @Override
        public void run() {
            Beat beat = (Beat)this.key.attachment();
            SocketChannel channel = (SocketChannel)this.key.channel();
            try {
                ByteBuffer buffer;
                if (!beat.isHealthy()) {
                    this.key.cancel();
                    this.key.channel().close();
                    beat.finishCheck();
                    return;
                }
                if (this.key.isValid() && this.key.isConnectable()) {
                    channel.finishConnect();
                    beat.finishCheck(true, false, System.currentTimeMillis() - beat.getTask().getStartTime(), "tcp:ok+");
                }
                if (this.key.isValid() && this.key.isReadable() && channel.read(buffer = ByteBuffer.allocate(128)) == -1) {
                    this.key.cancel();
                    this.key.channel().close();
                }
            }
            catch (ConnectException e) {
                beat.finishCheck(false, true, TcpSuperSenseProcessor.this.switchDomain.getTcpHealthParams().getMax(), "tcp:unable2connect:" + e.getMessage());
            }
            catch (Exception e) {
                beat.finishCheck(false, false, TcpSuperSenseProcessor.this.switchDomain.getTcpHealthParams().getMax(), "tcp:error:" + e.getMessage());
                try {
                    this.key.cancel();
                    this.key.channel().close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

