/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.healthcheck;

import com.alibaba.nacos.naming.core.Instance;
import com.alibaba.nacos.naming.misc.Loggers;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class HealthCheckStatus {
    public AtomicBoolean isBeingChecked = new AtomicBoolean(false);
    public AtomicInteger checkFailCount = new AtomicInteger(0);
    public AtomicInteger checkOkCount = new AtomicInteger(0);
    public long checkRt = -1L;
    private static ConcurrentMap<String, HealthCheckStatus> statusMap = new ConcurrentHashMap<String, HealthCheckStatus>();

    public static void reset(Instance instance) {
        statusMap.put(HealthCheckStatus.buildKey(instance), new HealthCheckStatus());
    }

    public static HealthCheckStatus get(Instance instance) {
        String key = HealthCheckStatus.buildKey(instance);
        if (!statusMap.containsKey(key)) {
            statusMap.putIfAbsent(key, new HealthCheckStatus());
        }
        return (HealthCheckStatus)statusMap.get(key);
    }

    public static void remv(Instance instance) {
        statusMap.remove(HealthCheckStatus.buildKey(instance));
    }

    private static String buildKey(Instance instance) {
        try {
            String clusterName = instance.getClusterName();
            String serviceName = instance.getServiceName();
            String datumKey = instance.getDatumKey();
            return serviceName + ":" + clusterName + ":" + datumKey;
        }
        catch (Throwable e) {
            Loggers.SRV_LOG.error("[BUILD-KEY] Exception while set rt, ip {}, error: {}", (Object)instance.toJson(), (Object)e);
            return instance.getDefaultKey();
        }
    }
}

