/*
 * Decompiled with CFR 0.152.
 */
package org.jeewx.api.wxuser.tag;

import java.util.HashMap;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jeewx.api.core.common.WxstoreUtils;
import org.jeewx.api.core.exception.WexinReqException;
import org.jeewx.api.core.util.WeiXinConstant;
import org.jeewx.api.wxuser.tag.model.WxTag;
import org.jeewx.api.wxuser.tag.model.WxTagUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwTagAPI {
    private static Logger logger = LoggerFactory.getLogger(JwTagAPI.class);
    private static String create_tag = "https://api.weixin.qq.com/cgi-bin/tags/create?access_token=ACCESS_TOKEN";
    private static String get_tag = "https://api.weixin.qq.com/cgi-bin/tags/get?access_token=ACCESS_TOKEN";
    private static String update_tag = "https://api.weixin.qq.com/cgi-bin/tags/update?access_token=ACCESS_TOKEN";
    private static String delete_tag = "https://api.weixin.qq.com/cgi-bin/tags/delete?access_token=ACCESS_TOKEN";
    private static String get_tag_user = "https://api.weixin.qq.com/cgi-bin/user/tag/get?access_token=ACCESS_TOKEN";
    private static String batchtagging = "https://api.weixin.qq.com/cgi-bin/tags/members/batchtagging?access_token=ACCESS_TOKEN";
    private static String batchuntagging = "https://api.weixin.qq.com/cgi-bin/tags/members/batchuntagging?access_token=ACCESS_TOKEN";
    private static String getidlist = "https://api.weixin.qq.com/cgi-bin/tags/getidlist?access_token=ACCESS_TOKEN";

    public static JSONObject createTag(String accessToken, String tagName) throws WexinReqException {
        JSONObject result = null;
        if (accessToken != null) {
            String requestUrl = create_tag.replace("ACCESS_TOKEN", accessToken);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", tagName);
            JSONObject obj = new JSONObject();
            obj.put((Object)"tag", map);
            logger.info("\u521b\u5efa\u6807\u7b7e\u65b9\u6cd5\u6267\u884c\u524djson\u53c2\u6570---obj: " + obj.toString());
            result = WxstoreUtils.httpRequest(requestUrl, "POST", obj.toString());
            logger.info("\u521b\u5efa\u6807\u7b7e\u65b9\u6cd5\u6267\u884c\u540ejson\u53c2\u6570 : " + result.toString());
        }
        return result;
    }

    public static List<WxTag> getTags(String accessToken) {
        List list = null;
        if (accessToken != null) {
            String requestUrl = get_tag.replace("ACCESS_TOKEN", accessToken);
            JSONObject result = WxstoreUtils.httpRequest(requestUrl, "GET", null);
            Object error = result.get(WeiXinConstant.RETURN_ERROR_INFO_CODE);
            if (error == null) {
                String tags = result.getString("tags");
                JSONArray jsonArray = JSONArray.fromObject((Object)tags);
                list = JSONArray.toList((JSONArray)jsonArray, WxTag.class);
                return list;
            }
            logger.info("\u83b7\u53d6\u6807\u7b7e\u65b9\u6cd5\u6267\u884c\u540ejson\u53c2\u6570 : " + result.toString());
        }
        return list;
    }

    public static JSONObject updateTag(String accessToken, int id, String name) {
        JSONObject result = null;
        if (accessToken != null) {
            String requestUrl = update_tag.replace("ACCESS_TOKEN", accessToken);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("id", id);
            data.put("name", name);
            JSONObject obj = new JSONObject();
            obj.put((Object)"tag", data);
            logger.info("\u7f16\u8f91\u6807\u7b7e\u65b9\u6cd5\u6267\u884c\u524djson\u53c2\u6570---obj: " + obj.toString());
            result = WxstoreUtils.httpRequest(requestUrl, "POST", obj.toString());
            logger.info("\u7f16\u8f91\u6807\u7b7e\u65b9\u6cd5\u6267\u884c\u540ejson\u53c2\u6570 : " + result.toString());
        }
        return result;
    }

    public static JSONObject delete(String accessToken, String id) {
        JSONObject result = null;
        if (accessToken != null) {
            String requestUrl = delete_tag.replace("ACCESS_TOKEN", accessToken);
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("id", id);
            JSONObject obj = new JSONObject();
            obj.put((Object)"tag", data);
            logger.info("\u5220\u9664\u6807\u7b7e\u65b9\u6cd5\u6267\u884c\u524djson\u53c2\u6570---obj: " + obj.toString());
            result = WxstoreUtils.httpRequest(requestUrl, "POST", obj.toString());
            logger.info("\u5220\u9664\u6807\u7b7e\u65b9\u6cd5\u6267\u884c\u540ejson\u53c2\u6570 : " + result.toString());
        }
        return result;
    }

    public static WxTagUser getTagUser(String accessToken, int tagid, String next_openid) {
        WxTagUser tagUser = null;
        Object users = null;
        try {
            if (accessToken != null) {
                String requestUrl = get_tag_user.replace("ACCESS_TOKEN", accessToken);
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("tagid", tagid);
                data.put("next_openid", next_openid);
                JSONObject obj = JSONObject.fromObject(data);
                logger.info("\u83b7\u53d6\u6807\u7b7e\u4e0b\u7c89\u4e1d\u5217\u8868\u65b9\u6cd5\u6267\u884c\u524djson\u53c2\u6570---obj: " + obj.toString());
                JSONObject result = WxstoreUtils.httpRequest(requestUrl, "GET", obj.toString());
                Integer error = (Integer)result.get(WeiXinConstant.RETURN_ERROR_INFO_CODE);
                if (error == null) {
                    tagUser = (WxTagUser)JSONObject.toBean((JSONObject)result, WxTagUser.class);
                }
                logger.info("\u83b7\u53d6\u6807\u7b7e\u4e0b\u7c89\u4e1d\u5217\u8868\u65b9\u6cd5\u6267\u884c\u540ejson\u53c2\u6570 : " + result.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tagUser;
    }

    public static JSONObject batchtagging(String accessToken, List<String> openid_list, int tagid) {
        JSONObject result = null;
        if (accessToken != null) {
            String requestUrl = batchtagging.replace("ACCESS_TOKEN", accessToken);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("openid_list", openid_list);
            data.put("tagid", tagid);
            JSONObject obj = JSONObject.fromObject(data);
            logger.info("\u6279\u91cf\u4e3a\u7528\u6237\u6253\u6807\u7b7e \u65b9\u6cd5\u6267\u884c\u524djson\u53c2\u6570---obj: " + obj.toString());
            result = WxstoreUtils.httpRequest(requestUrl, "POST", obj.toString());
            logger.info("\u6279\u91cf\u4e3a\u7528\u6237\u6253\u6807\u7b7e \u65b9\u6cd5\u6267\u884c\u540ejson\u53c2\u6570 : " + result.toString());
        }
        return result;
    }

    public static JSONObject batchuntagging(String accessToken, List<String> openid_list, int tagid) {
        JSONObject result = null;
        if (accessToken != null) {
            String requestUrl = batchuntagging.replace("ACCESS_TOKEN", accessToken);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("openid_list", openid_list);
            data.put("tagid", tagid);
            JSONObject obj = JSONObject.fromObject(data);
            logger.info("\u6279\u91cf\u4e3a\u7528\u6237\u53d6\u6d88\u6807\u7b7e \u65b9\u6cd5\u6267\u884c\u524djson\u53c2\u6570---obj: " + obj.toString());
            result = WxstoreUtils.httpRequest(requestUrl, "POST", obj.toString());
            logger.info("\u6279\u91cf\u4e3a\u7528\u6237\u53d6\u6d88\u6807\u7b7e \u65b9\u6cd5\u6267\u884c\u540ejson\u53c2\u6570 : " + result.toString());
        }
        return result;
    }

    public static List<Integer> getidlist(String accessToken, String openid) {
        List list = null;
        if (accessToken != null) {
            String requestUrl = getidlist.replace("ACCESS_TOKEN", accessToken);
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("openid", openid);
            JSONObject obj = JSONObject.fromObject(data);
            logger.info("\u83b7\u53d6\u7528\u6237\u8eab\u4e0a\u7684\u6807\u7b7e\u5217\u8868 \u65b9\u6cd5\u6267\u884c\u524djson\u53c2\u6570---obj: " + obj.toString());
            JSONObject result = WxstoreUtils.httpRequest(requestUrl, "POST", obj.toString());
            Object error = result.get(WeiXinConstant.RETURN_ERROR_INFO_CODE);
            if (error == null) {
                JSONArray jsonArray = result.getJSONArray("tagid_list");
                list = JSONArray.toList((JSONArray)jsonArray, Integer.class);
            }
            logger.info("\u83b7\u53d6\u7528\u6237\u8eab\u4e0a\u7684\u6807\u7b7e\u5217\u8868 \u65b9\u6cd5\u6267\u884c\u540ejson\u53c2\u6570 : " + result.toString());
        }
        return list;
    }
}

