/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.dingtalk.api.user;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jeecg.dingtalk.api.core.response.Response;
import com.jeecg.dingtalk.api.core.util.ApiUrls;
import com.jeecg.dingtalk.api.core.util.HttpUtil;
import com.jeecg.dingtalk.api.core.util.JdtTypes;
import com.jeecg.dingtalk.api.core.vo.PageResult;
import com.jeecg.dingtalk.api.user.body.GetUserListBody;
import com.jeecg.dingtalk.api.user.vo.User;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdtUserAPI {
    private static final Logger logger = LoggerFactory.getLogger(JdtUserAPI.class);

    public static Response<String> create(User user, String accessToken) {
        String url = ApiUrls.get("https://oapi.dingtalk.com/topapi/v2/user/create?access_token=%s", accessToken);
        Response originResponse = HttpUtil.post(url, JSON.toJSONString((Object)user), new Type[0]);
        Response<String> response = new Response<String>(originResponse);
        if (response.isSuccess()) {
            String userid = ((JSONObject)originResponse.getResult()).getString("userid");
            response.setResult(userid);
        }
        logger.info("[USER_CREATE] response:{}", new Object[]{JSON.toJSONString(response)});
        return response;
    }

    public static Response<JSONObject> update(User user, String accessToken) {
        String url = ApiUrls.get("https://oapi.dingtalk.com/topapi/v2/user/update?access_token=%s", accessToken);
        Response<JSONObject> response = HttpUtil.post(url, JSON.toJSONString((Object)user), new Type[0]);
        logger.info("[USER_UPDATE] response:{}", new Object[]{JSON.toJSONString(response)});
        return response;
    }

    public static Response<JSONObject> delete(String userid, String accessToken) {
        String url = ApiUrls.get("https://oapi.dingtalk.com/topapi/v2/user/delete?access_token=%s", accessToken);
        JSONObject body = new JSONObject();
        body.put("userid", (Object)userid);
        Response<JSONObject> response = HttpUtil.post(url, body.toJSONString(), new Type[0]);
        logger.info("[USER_DELETE] response:{}", new Object[]{JSON.toJSONString(response)});
        return response;
    }

    public static List<Response<JSONObject>> batchDeletePseudo(Collection<String> userIds, String accessToken) {
        ArrayList<Response<JSONObject>> list = new ArrayList<Response<JSONObject>>();
        boolean result = false;
        for (String userId : userIds) {
            list.add(JdtUserAPI.delete(userId, accessToken));
        }
        return list;
    }

    public static Response<User> getUserById(String userid, String accessToken) {
        String url = ApiUrls.get("https://oapi.dingtalk.com/topapi/v2/user/get?access_token=%s", accessToken);
        JSONObject body = new JSONObject();
        body.put("userid", (Object)userid);
        Response<User> response = HttpUtil.post(url, body.toJSONString(), new Type[]{User.class});
        logger.info("[USER_GET_BY_ID] response:{}", new Object[]{JSON.toJSONString(response)});
        return response;
    }

    public static Response<PageResult<User>> getUserListByDeptId(GetUserListBody body, String accessToken) {
        String url = ApiUrls.get("https://oapi.dingtalk.com/topapi/v2/user/list?access_token=%s", accessToken);
        Response<PageResult<User>> response = HttpUtil.post(url, JSON.toJSONString((Object)body), JdtTypes.PageResult_User);
        logger.info("[USER_GET_LIST_BY_DEPT_ID] response:{}", new Object[]{JSON.toJSONString(response)});
        return response;
    }

    public static Response<PageResult<User>> getUserListSimpleByDeptId(GetUserListBody body, String accessToken) {
        String url = ApiUrls.get("https://oapi.dingtalk.com/topapi/user/listsimple?access_token=%s", accessToken);
        Response<PageResult<User>> response = HttpUtil.post(url, JSON.toJSONString((Object)body), JdtTypes.PageResult_User);
        logger.info("[USER_GET_LIST_SIMPLE_BY_DEPT_ID] response:{}", new Object[]{JSON.toJSONString(response)});
        return response;
    }

    public static Response<List<String>> getUserListIdByDeptId(int deptId, String accessToken) {
        String url = ApiUrls.get("https://oapi.dingtalk.com/topapi/user/listid?access_token=%s", accessToken);
        JSONObject body = new JSONObject();
        body.put("dept_id", (Object)deptId);
        Response originResponse = HttpUtil.post(url, JSON.toJSONString((Object)body), new Type[0]);
        Response<List<String>> response = new Response<List<String>>(originResponse);
        if (response.isSuccess()) {
            List userid_list = ((JSONObject)originResponse.getResult()).getJSONArray("userid_list").toJavaList(String.class);
            response.setResult(userid_list);
        }
        logger.info("[USER_GET_LIST_ID_BY_DEPT_ID] response:{}", new Object[]{JSON.toJSONString(response)});
        return response;
    }

    public static Response<Integer> getUserCount(boolean onlyActive, String accessToken) {
        String url = ApiUrls.get("https://oapi.dingtalk.com/topapi/user/count?access_token=%s", accessToken);
        JSONObject body = new JSONObject();
        body.put("only_active", (Object)onlyActive);
        Response originResponse = HttpUtil.post(url, JSON.toJSONString((Object)body), new Type[0]);
        Response<Integer> response = new Response<Integer>(originResponse);
        if (response.isSuccess()) {
            response.setResult(((JSONObject)originResponse.getResult()).getIntValue("count"));
        }
        logger.info("[USER_COUNT] response:{}", new Object[]{JSON.toJSONString(response)});
        return response;
    }

    public static Response<Integer> getUserCount(String accessToken) {
        return JdtUserAPI.getUserCount(false, accessToken);
    }

    public static Response<String> getUseridByMobile(String mobile, String accessToken) {
        String url = ApiUrls.get("https://oapi.dingtalk.com/topapi/v2/user/getbymobile?access_token=%s", accessToken);
        JSONObject body = new JSONObject();
        body.put("mobile", (Object)mobile);
        Response originResponse = HttpUtil.post(url, JSON.toJSONString((Object)body), new Type[0]);
        Response<String> response = new Response<String>(originResponse);
        if (response.isSuccess()) {
            String userid = ((JSONObject)originResponse.getResult()).getString("userid");
            response.setResult(userid);
        }
        logger.info("[USER_GET_ID_BY_MOBILE] response:{}", new Object[]{JSON.toJSONString(response)});
        return response;
    }

    public static Response<String> getUseridByUnionid(String unionid, String accessToken) {
        String url = ApiUrls.get("https://oapi.dingtalk.com/topapi/user/getbyunionid?access_token=%s", accessToken);
        JSONObject body = new JSONObject();
        body.put("unionid", (Object)unionid);
        Response originResponse = HttpUtil.post(url, JSON.toJSONString((Object)body), new Type[0]);
        Response<String> response = new Response<String>(originResponse);
        if (response.isSuccess()) {
            String userid = ((JSONObject)originResponse.getResult()).getString("userid");
            response.setResult(userid);
        }
        logger.info("[USER_GET_ID_BY_UNIONID] response:{}", new Object[]{JSON.toJSONString(response)});
        return response;
    }
}

