/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.dingtalk.api.oauth2;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jeecg.dingtalk.api.core.util.ApiUrls;
import com.jeecg.dingtalk.api.core.util.HttpUtil;
import com.jeecg.dingtalk.api.oauth2.vo.ContactUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdtOauth2API {
    private static final Logger logger = LoggerFactory.getLogger(JdtOauth2API.class);

    public static String getUserAccessToken(String clientId, String clientSecret, String code) {
        String accessToken;
        JSONObject params = new JSONObject();
        params.put("clientId", (Object)clientId);
        params.put("clientSecret", (Object)clientSecret);
        params.put("code", (Object)code);
        params.put("grantType", (Object)"authorization_code");
        String url = "https://api.dingtalk.com/v1.0/oauth2/userAccessToken";
        JSONObject response = HttpUtil.sendPost(url, params.toJSONString());
        logger.info("[GET_USER_ACCESS_TOKEN] response:{}", new Object[]{JSON.toJSONString((Object)response)});
        if (response != null && (accessToken = response.getString("accessToken")) != null && accessToken.length() > 0) {
            return accessToken;
        }
        return null;
    }

    public static ContactUser getContactUsers(String unionId, String accessToken) {
        String url = ApiUrls.get("https://api.dingtalk.com/v1.0/contact/users/%s", unionId);
        JSONObject headers = new JSONObject();
        headers.put("x-acs-dingtalk-access-token", (Object)accessToken);
        JSONObject json = HttpUtil.httpRequest(url, "GET", null, headers);
        if (json != null) {
            logger.info("[GET_CONTACT_USERS] response:{}", new Object[]{json.toJSONString()});
            return (ContactUser)json.toJavaObject(ContactUser.class);
        }
        logger.error("[GET_CONTACT_USERS] response: null");
        return null;
    }
}

