/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.dashboard.service;

import com.alibaba.csp.sentinel.dashboard.client.SentinelApiClient;
import com.alibaba.csp.sentinel.dashboard.domain.cluster.ClusterAppAssignResultVO;
import com.alibaba.csp.sentinel.dashboard.domain.cluster.ClusterGroupEntity;
import com.alibaba.csp.sentinel.dashboard.domain.cluster.config.ClusterClientConfig;
import com.alibaba.csp.sentinel.dashboard.domain.cluster.config.ServerFlowConfig;
import com.alibaba.csp.sentinel.dashboard.domain.cluster.config.ServerTransportConfig;
import com.alibaba.csp.sentinel.dashboard.domain.cluster.request.ClusterAppAssignMap;
import com.alibaba.csp.sentinel.dashboard.domain.cluster.state.ClusterUniversalStatePairVO;
import com.alibaba.csp.sentinel.dashboard.service.ClusterAssignService;
import com.alibaba.csp.sentinel.dashboard.service.ClusterConfigService;
import com.alibaba.csp.sentinel.dashboard.util.MachineUtils;
import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.csp.sentinel.util.function.Tuple2;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ClusterAssignServiceImpl
implements ClusterAssignService {
    private final Logger LOGGER = LoggerFactory.getLogger(ClusterAssignServiceImpl.class);
    @Autowired
    private SentinelApiClient sentinelApiClient;
    @Autowired
    private ClusterConfigService clusterConfigService;

    private boolean isMachineInApp(String machineId) {
        return machineId.contains(":");
    }

    private ClusterAppAssignResultVO handleUnbindClusterServerNotInApp(String app, String machineId) {
        HashSet<String> failedSet = new HashSet<String>();
        try {
            List<ClusterUniversalStatePairVO> list = this.clusterConfigService.getClusterUniversalState(app).get(10L, TimeUnit.SECONDS);
            Set<String> toModifySet = list.stream().filter(e -> e.getState().getStateInfo().getMode() == 0).filter(e -> machineId.equals(e.getState().getClient().getClientConfig().getServerHost() + ':' + e.getState().getClient().getClientConfig().getServerPort())).map(e -> e.getIp() + '@' + e.getCommandPort()).collect(Collectors.toSet());
            this.modifyToNonStarted(toModifySet, failedSet);
        }
        catch (Exception ex) {
            Throwable e2 = ex instanceof ExecutionException ? ex.getCause() : ex;
            this.LOGGER.error("Failed to unbind machine <{}>", (Object)machineId, (Object)e2);
            failedSet.add(machineId);
        }
        return new ClusterAppAssignResultVO().setFailedClientSet(failedSet).setFailedServerSet(new HashSet<String>());
    }

    private void modifyToNonStarted(Set<String> toModifySet, Set<String> failedSet) {
        toModifySet.parallelStream().map(MachineUtils::parseCommandIpAndPort).filter(Optional::isPresent).map(Optional::get).map(e -> {
            CompletableFuture<Void> f = this.modifyMode((String)e.r1, (Integer)e.r2, -1);
            return Tuple2.of((Object)((String)e.r1 + '@' + e.r2), f);
        }).forEach(f -> this.handleFutureSync((Tuple2<String, CompletableFuture<Void>>)f, failedSet));
    }

    @Override
    public ClusterAppAssignResultVO unbindClusterServer(String app, String machineId) {
        AssertUtil.assertNotBlank((String)app, (String)"app cannot be blank");
        AssertUtil.assertNotBlank((String)machineId, (String)"machineId cannot be blank");
        if (this.isMachineInApp(machineId)) {
            return this.handleUnbindClusterServerNotInApp(app, machineId);
        }
        HashSet<String> failedSet = new HashSet<String>();
        try {
            ClusterGroupEntity entity = this.clusterConfigService.getClusterUniversalStateForAppMachine(app, machineId).get(10L, TimeUnit.SECONDS);
            HashSet<String> toModifySet = new HashSet<String>();
            toModifySet.add(machineId);
            if (entity.getClientSet() != null) {
                toModifySet.addAll(entity.getClientSet());
            }
            this.modifyToNonStarted(toModifySet, failedSet);
        }
        catch (Exception ex) {
            Throwable e = ex instanceof ExecutionException ? ex.getCause() : ex;
            this.LOGGER.error("Failed to unbind machine <{}>", (Object)machineId, (Object)e);
            failedSet.add(machineId);
        }
        return new ClusterAppAssignResultVO().setFailedClientSet(failedSet).setFailedServerSet(new HashSet<String>());
    }

    @Override
    public ClusterAppAssignResultVO unbindClusterServers(String app, Set<String> machineIdSet) {
        AssertUtil.assertNotBlank((String)app, (String)"app cannot be blank");
        AssertUtil.isTrue((machineIdSet != null && !machineIdSet.isEmpty() ? 1 : 0) != 0, (String)"machineIdSet cannot be empty");
        ClusterAppAssignResultVO result = new ClusterAppAssignResultVO().setFailedClientSet(new HashSet<String>()).setFailedServerSet(new HashSet<String>());
        for (String machineId : machineIdSet) {
            ClusterAppAssignResultVO resultVO = this.unbindClusterServer(app, machineId);
            result.getFailedClientSet().addAll(resultVO.getFailedClientSet());
            result.getFailedServerSet().addAll(resultVO.getFailedServerSet());
        }
        return result;
    }

    @Override
    public ClusterAppAssignResultVO applyAssignToApp(String app, List<ClusterAppAssignMap> clusterMap, Set<String> remainingSet) {
        AssertUtil.assertNotBlank((String)app, (String)"app cannot be blank");
        AssertUtil.notNull(clusterMap, (String)"clusterMap cannot be null");
        HashSet<String> failedServerSet = new HashSet<String>();
        HashSet<String> failedClientSet = new HashSet<String>();
        clusterMap.stream().filter(Objects::nonNull).filter(ClusterAppAssignMap::getBelongToApp).map(e -> {
            String ip = e.getIp();
            int commandPort = this.parsePort((ClusterAppAssignMap)e);
            CompletionStage f = this.modifyMode(ip, commandPort, 1).thenCompose(v -> this.applyServerConfigChange(app, ip, commandPort, (ClusterAppAssignMap)e));
            return Tuple2.of((Object)e.getMachineId(), (Object)f);
        }).forEach(t -> this.handleFutureSync((Tuple2<String, CompletableFuture<Void>>)t, failedServerSet));
        clusterMap.parallelStream().filter(Objects::nonNull).forEach(e -> this.applyAllClientConfigChange(app, (ClusterAppAssignMap)e, (Set<String>)failedClientSet));
        this.applyAllRemainingMachineSet(app, remainingSet, failedClientSet);
        return new ClusterAppAssignResultVO().setFailedClientSet(failedClientSet).setFailedServerSet(failedServerSet);
    }

    private void applyAllRemainingMachineSet(String app, Set<String> remainingSet, Set<String> failedSet) {
        if (remainingSet == null || remainingSet.isEmpty()) {
            return;
        }
        remainingSet.parallelStream().filter(Objects::nonNull).map(MachineUtils::parseCommandIpAndPort).filter(Optional::isPresent).map(Optional::get).map(ipPort -> {
            String ip = (String)ipPort.r1;
            int commandPort = (Integer)ipPort.r2;
            CompletableFuture<Void> f = this.modifyMode(ip, commandPort, -1);
            return Tuple2.of((Object)(ip + '@' + commandPort), f);
        }).forEach(t -> this.handleFutureSync((Tuple2<String, CompletableFuture<Void>>)t, failedSet));
    }

    private void applyAllClientConfigChange(String app, ClusterAppAssignMap assignMap, Set<String> failedSet) {
        Set<String> clientSet = assignMap.getClientSet();
        if (clientSet == null || clientSet.isEmpty()) {
            return;
        }
        String serverIp = assignMap.getIp();
        int serverPort = assignMap.getPort();
        clientSet.stream().map(MachineUtils::parseCommandIpAndPort).filter(Optional::isPresent).map(Optional::get).map(ipPort -> {
            CompletionStage f = this.sentinelApiClient.modifyClusterMode((String)ipPort.r1, (Integer)ipPort.r2, 0).thenCompose(v -> this.sentinelApiClient.modifyClusterClientConfig(app, (String)ipPort.r1, (Integer)ipPort.r2, new ClusterClientConfig().setRequestTimeout(20).setServerHost(serverIp).setServerPort(serverPort)));
            return Tuple2.of((Object)((String)ipPort.r1 + '@' + ipPort.r2), (Object)f);
        }).forEach(t -> this.handleFutureSync((Tuple2<String, CompletableFuture<Void>>)t, failedSet));
    }

    private void handleFutureSync(Tuple2<String, CompletableFuture<Void>> t, Set<String> failedSet) {
        try {
            ((CompletableFuture)t.r2).get(10L, TimeUnit.SECONDS);
        }
        catch (Exception ex) {
            if (ex instanceof ExecutionException) {
                this.LOGGER.error("Request for <{}> failed", t.r1, (Object)ex.getCause());
            } else {
                this.LOGGER.error("Request for <{}> failed", t.r1, (Object)ex);
            }
            failedSet.add((String)t.r1);
        }
    }

    private CompletableFuture<Void> applyServerConfigChange(String app, String ip, int commandPort, ClusterAppAssignMap assignMap) {
        ServerTransportConfig transportConfig = new ServerTransportConfig().setPort(assignMap.getPort()).setIdleSeconds(600);
        return ((CompletableFuture)this.sentinelApiClient.modifyClusterServerTransportConfig(app, ip, commandPort, transportConfig).thenCompose(v -> this.applyServerFlowConfigChange(app, ip, commandPort, assignMap))).thenCompose(v -> this.applyServerNamespaceSetConfig(app, ip, commandPort, assignMap));
    }

    private CompletableFuture<Void> applyServerFlowConfigChange(String app, String ip, int commandPort, ClusterAppAssignMap assignMap) {
        Double maxAllowedQps = assignMap.getMaxAllowedQps();
        if (maxAllowedQps == null || maxAllowedQps <= 0.0 || maxAllowedQps > 200000.0) {
            return CompletableFuture.completedFuture(null);
        }
        return this.sentinelApiClient.modifyClusterServerFlowConfig(app, ip, commandPort, new ServerFlowConfig().setMaxAllowedQps(maxAllowedQps));
    }

    private CompletableFuture<Void> applyServerNamespaceSetConfig(String app, String ip, int commandPort, ClusterAppAssignMap assignMap) {
        Set<String> namespaceSet = assignMap.getNamespaceSet();
        if (namespaceSet == null || namespaceSet.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        return this.sentinelApiClient.modifyClusterServerNamespaceSet(app, ip, commandPort, namespaceSet);
    }

    private CompletableFuture<Void> modifyMode(String ip, int port, int mode) {
        return this.sentinelApiClient.modifyClusterMode(ip, port, mode);
    }

    private int parsePort(ClusterAppAssignMap assignMap) {
        return MachineUtils.parseCommandPort(assignMap.getMachineId()).orElse(18730);
    }
}

