/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.dashboard.repository.rule;

import com.alibaba.csp.sentinel.dashboard.datasource.entity.rule.RuleEntity;
import com.alibaba.csp.sentinel.dashboard.discovery.MachineInfo;
import com.alibaba.csp.sentinel.dashboard.repository.rule.RuleRepository;
import com.alibaba.csp.sentinel.util.AssertUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class InMemoryRuleRepositoryAdapter<T extends RuleEntity>
implements RuleRepository<T, Long> {
    private Map<MachineInfo, Map<Long, T>> machineRules = new ConcurrentHashMap<MachineInfo, Map<Long, T>>(16);
    private Map<Long, T> allRules = new ConcurrentHashMap<Long, T>(16);
    private Map<String, Map<Long, T>> appRules = new ConcurrentHashMap<String, Map<Long, T>>(16);
    private static final int MAX_RULES_SIZE = 10000;

    @Override
    public T save(T entity) {
        T processedEntity;
        if (entity.getId() == null) {
            entity.setId(this.nextId());
        }
        if ((processedEntity = this.preProcess(entity)) != null) {
            this.allRules.put(processedEntity.getId(), processedEntity);
            this.machineRules.computeIfAbsent(MachineInfo.of(processedEntity.getApp(), processedEntity.getIp(), processedEntity.getPort()), e -> new ConcurrentHashMap(32)).put(processedEntity.getId(), processedEntity);
            this.appRules.computeIfAbsent(processedEntity.getApp(), v -> new ConcurrentHashMap(32)).put(processedEntity.getId(), processedEntity);
        }
        return processedEntity;
    }

    @Override
    public List<T> saveAll(List<T> rules) {
        this.allRules.clear();
        this.machineRules.clear();
        this.appRules.clear();
        if (rules == null) {
            return null;
        }
        ArrayList<RuleEntity> savedRules = new ArrayList<RuleEntity>(rules.size());
        for (RuleEntity rule : rules) {
            savedRules.add(this.save((T)rule));
        }
        return savedRules;
    }

    @Override
    public T delete(Long id) {
        RuleEntity entity = (RuleEntity)this.allRules.remove(id);
        if (entity != null) {
            if (this.appRules.get(entity.getApp()) != null) {
                this.appRules.get(entity.getApp()).remove(id);
            }
            this.machineRules.get(MachineInfo.of(entity.getApp(), entity.getIp(), entity.getPort())).remove(id);
        }
        return (T)entity;
    }

    @Override
    public T findById(Long id) {
        return (T)((RuleEntity)this.allRules.get(id));
    }

    @Override
    public List<T> findAllByMachine(MachineInfo machineInfo) {
        Map<Long, T> entities = this.machineRules.get(machineInfo);
        if (entities == null) {
            return new ArrayList();
        }
        return new ArrayList<T>(entities.values());
    }

    @Override
    public List<T> findAllByApp(String appName) {
        AssertUtil.notEmpty((String)appName, (String)"appName cannot be empty");
        Map<Long, T> entities = this.appRules.get(appName);
        if (entities == null) {
            return new ArrayList();
        }
        return new ArrayList<T>(entities.values());
    }

    public void clearAll() {
        this.allRules.clear();
        this.machineRules.clear();
        this.appRules.clear();
    }

    protected T preProcess(T entity) {
        return entity;
    }

    protected abstract long nextId();
}

