/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.dashboard.datasource.entity;

public class SentinelVersion {
    private int majorVersion;
    private int minorVersion;
    private int fixVersion;
    private String postfix;

    public SentinelVersion() {
        this(0, 0, 0);
    }

    public SentinelVersion(int major, int minor, int fix) {
        this(major, minor, fix, null);
    }

    public SentinelVersion(int major, int minor, int fix, String postfix) {
        this.majorVersion = major;
        this.minorVersion = minor;
        this.fixVersion = fix;
        this.postfix = postfix;
    }

    public int getFullVersion() {
        return this.majorVersion * 1000000 + this.minorVersion * 1000 + this.fixVersion;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public SentinelVersion setMajorVersion(int majorVersion) {
        this.majorVersion = majorVersion;
        return this;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public SentinelVersion setMinorVersion(int minorVersion) {
        this.minorVersion = minorVersion;
        return this;
    }

    public int getFixVersion() {
        return this.fixVersion;
    }

    public SentinelVersion setFixVersion(int fixVersion) {
        this.fixVersion = fixVersion;
        return this;
    }

    public String getPostfix() {
        return this.postfix;
    }

    public SentinelVersion setPostfix(String postfix) {
        this.postfix = postfix;
        return this;
    }

    public boolean greaterThan(SentinelVersion version) {
        if (version == null) {
            return true;
        }
        return this.getFullVersion() > version.getFullVersion();
    }

    public boolean greaterOrEqual(SentinelVersion version) {
        if (version == null) {
            return true;
        }
        return this.getFullVersion() >= version.getFullVersion();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SentinelVersion that = (SentinelVersion)o;
        if (this.getFullVersion() != that.getFullVersion()) {
            return false;
        }
        return this.postfix != null ? this.postfix.equals(that.postfix) : that.postfix == null;
    }

    public int hashCode() {
        int result = this.majorVersion;
        result = 31 * result + this.minorVersion;
        result = 31 * result + this.fixVersion;
        result = 31 * result + (this.postfix != null ? this.postfix.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "SentinelVersion{majorVersion=" + this.majorVersion + ", minorVersion=" + this.minorVersion + ", fixVersion=" + this.fixVersion + ", postfix='" + this.postfix + '\'' + '}';
    }
}

