/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.internal.proxy.processors;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.WebTarget;
import org.jboss.resteasy.client.jaxrs.internal.ClientConfiguration;
import org.jboss.resteasy.client.jaxrs.internal.ClientInvocationBuilder;
import org.jboss.resteasy.client.jaxrs.internal.proxy.processors.InvocationProcessor;
import org.jboss.resteasy.client.jaxrs.internal.proxy.processors.ProcessorFactory;
import org.jboss.resteasy.client.jaxrs.internal.proxy.processors.WebTargetProcessor;
import org.jboss.resteasy.spi.LoggableFailure;

public class FormProcessor
implements InvocationProcessor,
WebTargetProcessor {
    protected HashMap<Field, Object> fieldMap = new HashMap();
    protected List<GetterMethod> getters = new ArrayList<GetterMethod>();
    protected HashMap<Long, Method> getterHashes = new HashMap();
    protected Class clazz;

    public FormProcessor(Class clazz, ClientConfiguration configuration) {
        this.clazz = clazz;
        this.populateMap(clazz, configuration);
    }

    public static long methodHash(Method method) throws Exception {
        Class<?>[] parameterTypes = method.getParameterTypes();
        StringBuilder methodDesc = new StringBuilder(method.getName()).append("(");
        for (int j = 0; j < parameterTypes.length; ++j) {
            methodDesc.append(FormProcessor.getTypeString(parameterTypes[j]));
        }
        methodDesc.append(")").append(FormProcessor.getTypeString(method.getReturnType()));
        return FormProcessor.createHash(methodDesc.toString());
    }

    public static long createHash(String methodDesc) throws Exception {
        long hash = 0L;
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream(512);
        MessageDigest messagedigest = MessageDigest.getInstance("SHA");
        DataOutputStream dataoutputstream = new DataOutputStream(new DigestOutputStream(bytearrayoutputstream, messagedigest));
        dataoutputstream.writeUTF(methodDesc);
        dataoutputstream.flush();
        byte[] abyte0 = messagedigest.digest();
        for (int j = 0; j < Math.min(8, abyte0.length); ++j) {
            hash += (long)(abyte0[j] & 0xFF) << j * 8;
        }
        return hash;
    }

    static String getTypeString(Class cl) {
        if (cl == Byte.TYPE) {
            return "B";
        }
        if (cl == Character.TYPE) {
            return "C";
        }
        if (cl == Double.TYPE) {
            return "D";
        }
        if (cl == Float.TYPE) {
            return "F";
        }
        if (cl == Integer.TYPE) {
            return "I";
        }
        if (cl == Long.TYPE) {
            return "J";
        }
        if (cl == Short.TYPE) {
            return "S";
        }
        if (cl == Boolean.TYPE) {
            return "Z";
        }
        if (cl == Void.TYPE) {
            return "V";
        }
        if (cl.isArray()) {
            return "[" + FormProcessor.getTypeString(cl.getComponentType());
        }
        return "L" + cl.getName().replace('.', '/') + ";";
    }

    protected void populateMap(Class clazz, ClientConfiguration configuration) {
        Type genericType;
        Class<?> type;
        Object processor;
        Annotation[] annotations;
        for (Field field : clazz.getDeclaredFields()) {
            annotations = field.getAnnotations();
            if (annotations == null || annotations.length == 0 || (processor = ProcessorFactory.createProcessor(clazz, configuration, type = field.getType(), annotations, genericType = field.getGenericType(), field, true)) == null) continue;
            if (!Modifier.isPublic(field.getModifiers())) {
                field.setAccessible(true);
            }
            this.fieldMap.put(field, processor);
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
            Method older;
            if (!((Method)accessibleObject).getName().startsWith("get") || ((Method)accessibleObject).getParameterTypes().length > 0 || (annotations = accessibleObject.getAnnotations()) == null || annotations.length == 0 || (processor = ProcessorFactory.createProcessor(clazz, configuration, type = ((Method)accessibleObject).getReturnType(), annotations, genericType = ((Method)accessibleObject).getGenericReturnType(), accessibleObject, true)) == null) continue;
            long hash = 0L;
            try {
                hash = FormProcessor.methodHash((Method)accessibleObject);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (!Modifier.isPrivate(((Method)accessibleObject).getModifiers()) && (older = this.getterHashes.get(hash)) != null) continue;
            if (!Modifier.isPublic(((Method)accessibleObject).getModifiers())) {
                ((Method)accessibleObject).setAccessible(true);
            }
            this.getters.add(new GetterMethod((Method)accessibleObject, processor));
            this.getterHashes.put(hash, (Method)accessibleObject);
        }
        if (clazz.getSuperclass() != null && !clazz.getSuperclass().equals(Object.class)) {
            this.populateMap(clazz.getSuperclass(), configuration);
        }
    }

    @Override
    public WebTarget build(WebTarget target, Object param) {
        if (param == null) {
            return target;
        }
        return (WebTarget)this.process(new Process(){

            @Override
            public Object process(Object target, Object value, Object processor) {
                return FormProcessor.this.build((WebTarget)target, value, processor);
            }
        }, target, param);
    }

    @Override
    public void process(ClientInvocationBuilder invocation, Object param) {
        this.process(new Process(){

            @Override
            public Object process(Object target, Object value, Object processor) {
                FormProcessor.this.processParam((ClientInvocationBuilder)target, value, processor);
                return target;
            }
        }, invocation, param);
    }

    protected Object process(Process process, Object target, Object param) {
        Object proc;
        Object val;
        if (param == null) {
            return target;
        }
        for (Map.Entry<Field, Object> entry : this.fieldMap.entrySet()) {
            try {
                val = entry.getKey().get(param);
                proc = entry.getValue();
                target = process.process(target, val, proc);
            }
            catch (IllegalAccessException e) {
                throw new LoggableFailure((Throwable)e);
            }
        }
        for (GetterMethod getter : this.getters) {
            val = null;
            try {
                val = getter.method.invoke(param, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            proc = getter.processor;
            target = process.process(target, val, proc);
        }
        return target;
    }

    private WebTarget build(WebTarget target, Object val, Object proc) {
        if (proc instanceof WebTargetProcessor) {
            WebTargetProcessor processor = (WebTargetProcessor)proc;
            target = processor.build(target, val);
        }
        return target;
    }

    private void processParam(ClientInvocationBuilder invocation, Object val, Object proc) {
        if (proc instanceof InvocationProcessor) {
            InvocationProcessor processor = (InvocationProcessor)proc;
            processor.process(invocation, val);
        }
    }

    static interface Process {
        public Object process(Object var1, Object var2, Object var3);
    }

    private static class GetterMethod {
        public Method method;
        public Object processor;

        private GetterMethod(Method method, Object processor) {
            this.method = method;
            this.processor = processor;
        }
    }
}

