/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.EnumSet;
import java.util.concurrent.ConcurrentMap;
import org.jboss.logmanager.ConcurrentReferenceHashMap;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.LogContextSelector;

public final class ContextClassLoaderLogContextSelector
implements LogContextSelector {
    private static final Permission REGISTER_LOG_CONTEXT_PERMISSION = new RuntimePermission("registerLogContext", null);
    private static final Permission UNREGISTER_LOG_CONTEXT_PERMISSION = new RuntimePermission("unregisterLogContext", null);
    private final LogContextSelector defaultSelector;
    private final ConcurrentMap<ClassLoader, LogContext> contextMap = new ConcurrentReferenceHashMap<ClassLoader, LogContext>(16, 0.75f, 16, ConcurrentReferenceHashMap.ReferenceType.WEAK, ConcurrentReferenceHashMap.ReferenceType.WEAK, EnumSet.of(ConcurrentReferenceHashMap.Option.IDENTITY_COMPARISONS));
    private static final ContextClassLoaderAction CLASS_LOADER_ACTION = new ContextClassLoaderAction();

    public ContextClassLoaderLogContextSelector(LogContextSelector defaultSelector) {
        this.defaultSelector = defaultSelector;
    }

    public ContextClassLoaderLogContextSelector() {
        this(LogContext.DEFAULT_LOG_CONTEXT_SELECTOR);
    }

    @Override
    public LogContext getLogContext() {
        LogContext mappedContext;
        ClassLoader cl = ContextClassLoaderLogContextSelector.getContextClassLoader();
        if (cl != null && (mappedContext = (LogContext)this.contextMap.get(cl)) != null) {
            return mappedContext;
        }
        return this.defaultSelector.getLogContext();
    }

    private static ClassLoader getContextClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(CLASS_LOADER_ACTION);
        }
        return Thread.currentThread().getContextClassLoader();
    }

    public void registerLogContext(ClassLoader classLoader, LogContext logContext) throws IllegalArgumentException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(REGISTER_LOG_CONTEXT_PERMISSION);
        }
        if (this.contextMap.putIfAbsent(classLoader, logContext) != null) {
            throw new IllegalArgumentException("ClassLoader instance is already registered to a log context (" + classLoader + ")");
        }
    }

    public boolean unregisterLogContext(ClassLoader classLoader, LogContext logContext) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(UNREGISTER_LOG_CONTEXT_PERMISSION);
        }
        return this.contextMap.remove(classLoader, logContext);
    }

    private static class ContextClassLoaderAction
    implements PrivilegedAction<ClassLoader> {
        private ContextClassLoaderAction() {
        }

        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    }
}

