/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import java.util.ArrayList;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ModelVersionRange;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.parsing.ProfileParsingCompletionHandler;
import org.jboss.as.controller.registry.AliasEntry;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescription;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.jboss.as.web.DefaultJsfProfileCompletionHandler;
import org.jboss.as.web.Namespace;
import org.jboss.as.web.WebAccessLogDefinition;
import org.jboss.as.web.WebAccessLogDirectoryDefinition;
import org.jboss.as.web.WebConnectorDefinition;
import org.jboss.as.web.WebContainerDefinition;
import org.jboss.as.web.WebDefinition;
import org.jboss.as.web.WebDeploymentDefinition;
import org.jboss.as.web.WebDeploymentServletDefinition;
import org.jboss.as.web.WebJSPDefinition;
import org.jboss.as.web.WebMessages;
import org.jboss.as.web.WebReWriteConditionDefinition;
import org.jboss.as.web.WebReWriteDefinition;
import org.jboss.as.web.WebSSLDefinition;
import org.jboss.as.web.WebSSODefinition;
import org.jboss.as.web.WebStaticResources;
import org.jboss.as.web.WebSubsystemParser;
import org.jboss.as.web.WebValveDefinition;
import org.jboss.as.web.WebVirtualHostDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class WebExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "web";
    public static final PathElement SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)"web");
    protected static final PathElement CONNECTOR_PATH = PathElement.pathElement((String)"connector");
    protected static final PathElement SSL_PATH = PathElement.pathElement((String)"configuration", (String)"ssl");
    protected static final PathElement SSL_ALIAS = PathElement.pathElement((String)"ssl", (String)"configuration");
    protected static final PathElement HOST_PATH = PathElement.pathElement((String)"virtual-server");
    protected static final PathElement JSP_CONFIGURATION_PATH = PathElement.pathElement((String)"configuration", (String)"jsp-configuration");
    protected static final PathElement STATIC_RESOURCES_PATH = PathElement.pathElement((String)"configuration", (String)"static-resources");
    protected static final PathElement CONTAINER_PATH = PathElement.pathElement((String)"configuration", (String)"container");
    protected static final PathElement ACCESS_LOG_PATH = PathElement.pathElement((String)"configuration", (String)"access-log");
    protected static final PathElement ACCESS_LOG_ALIAS = PathElement.pathElement((String)"access-log", (String)"configuration");
    protected static final PathElement REWRITE_PATH = PathElement.pathElement((String)"rewrite");
    protected static final PathElement SSO_PATH = PathElement.pathElement((String)"configuration", (String)"sso");
    protected static final PathElement SSO_ALIAS = PathElement.pathElement((String)"sso", (String)"configuration");
    protected static final PathElement DIRECTORY_PATH = PathElement.pathElement((String)"setting", (String)"directory");
    protected static final PathElement DIRECTORY_ALIAS = PathElement.pathElement((String)"directory", (String)"configuration");
    protected static final PathElement REWRITECOND_PATH = PathElement.pathElement((String)"condition");
    public static final PathElement VALVE_PATH = PathElement.pathElement((String)"valve");
    protected static final PathElement PARAM = PathElement.pathElement((String)"param");
    private static final String RESOURCE_NAME = WebExtension.class.getPackage().getName() + ".LocalDescriptions";
    private static final int MANAGEMENT_API_MAJOR_VERSION = 1;
    private static final int MANAGEMENT_API_MINOR_VERSION = 2;
    private static final int MANAGEMENT_API_MICRO_VERSION = 0;

    static StandardResourceDescriptionResolver getResourceDescriptionResolver(String keyPrefix) {
        String prefix = SUBSYSTEM_NAME + (keyPrefix == null ? "" : "." + keyPrefix);
        return new StandardResourceDescriptionResolver(prefix, RESOURCE_NAME, WebExtension.class.getClassLoader(), true, false);
    }

    public void initialize(ExtensionContext context) {
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, 1, 2, 0);
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel((ResourceDefinition)WebDefinition.INSTANCE);
        registration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
        subsystem.registerXMLElementWriter((XMLElementWriter)WebSubsystemParser.getInstance());
        ManagementResourceRegistration connectors = registration.registerSubModel((ResourceDefinition)WebConnectorDefinition.INSTANCE);
        ManagementResourceRegistration ssl = connectors.registerSubModel((ResourceDefinition)WebSSLDefinition.INSTANCE);
        connectors.registerAlias(SSL_ALIAS, (AliasEntry)new StandardWebExtensionAliasEntry(ssl));
        ManagementResourceRegistration hosts = registration.registerSubModel((ResourceDefinition)WebVirtualHostDefinition.INSTANCE);
        ManagementResourceRegistration accesslog = hosts.registerSubModel((ResourceDefinition)WebAccessLogDefinition.INSTANCE);
        hosts.registerAlias(ACCESS_LOG_ALIAS, (AliasEntry)new StandardWebExtensionAliasEntry(accesslog));
        ManagementResourceRegistration accessLogDir = accesslog.registerSubModel((ResourceDefinition)WebAccessLogDirectoryDefinition.INSTANCE);
        accesslog.registerAlias(DIRECTORY_ALIAS, (AliasEntry)new StandardWebExtensionAliasEntry(accessLogDir));
        ManagementResourceRegistration sso = hosts.registerSubModel((ResourceDefinition)WebSSODefinition.INSTANCE);
        hosts.registerAlias(SSO_ALIAS, (AliasEntry)new StandardWebExtensionAliasEntry(sso));
        ManagementResourceRegistration rewrite = hosts.registerSubModel((ResourceDefinition)WebReWriteDefinition.INSTANCE);
        rewrite.registerSubModel((ResourceDefinition)WebReWriteConditionDefinition.INSTANCE);
        registration.registerSubModel((ResourceDefinition)WebJSPDefinition.INSTANCE);
        registration.registerSubModel((ResourceDefinition)WebStaticResources.INSTANCE);
        registration.registerSubModel((ResourceDefinition)WebContainerDefinition.INSTANCE);
        ManagementResourceRegistration deployments = subsystem.registerDeploymentModel((ResourceDefinition)WebDeploymentDefinition.INSTANCE);
        deployments.registerSubModel((ResourceDefinition)WebDeploymentServletDefinition.INSTANCE);
        registration.registerSubModel((ResourceDefinition)WebValveDefinition.INSTANCE);
        if (context.isRegisterTransformers()) {
            this.registerTransformers_1_1_0(subsystem);
        }
    }

    public void initializeParsers(ExtensionParsingContext context) {
        for (Namespace ns : Namespace.values()) {
            if (ns.getUriString() == null) continue;
            context.setSubsystemXmlMapping(SUBSYSTEM_NAME, ns.getUriString(), (XMLElementReader)WebSubsystemParser.getInstance());
        }
        context.setProfileParsingCompletionHandler((ProfileParsingCompletionHandler)new DefaultJsfProfileCompletionHandler());
    }

    private void registerTransformers_1_1_0(SubsystemRegistration registration) {
        int defaultRedirectPort = 443;
        ResourceTransformationDescriptionBuilder subsystemRoot = TransformationDescriptionBuilder.Factory.createSubsystemInstance();
        subsystemRoot.rejectChildResource(VALVE_PATH);
        subsystemRoot.addChildResource(JSP_CONFIGURATION_PATH).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, (AttributeDefinition[])WebJSPDefinition.JSP_ATTRIBUTES);
        subsystemRoot.addChildResource(STATIC_RESOURCES_PATH).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, (AttributeDefinition[])WebStaticResources.STATIC_ATTRIBUTES);
        subsystemRoot.addChildResource(CONTAINER_PATH).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, WebContainerDefinition.CONTAINER_ATTRIBUTES);
        ResourceTransformationDescriptionBuilder connectorBuilder = subsystemRoot.addChildResource(CONNECTOR_PATH);
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)connectorBuilder.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, (AttributeDefinition[])WebConnectorDefinition.CONNECTOR_ATTRIBUTES)).addRejectCheck((RejectAttributeChecker)new RejectAttributeChecker.DefaultRejectAttributeChecker(){

            protected boolean rejectAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
                return attributeValue.isDefined();
            }

            public String getRejectionLogMessage(Map<String, ModelNode> attributes) {
                return WebMessages.MESSAGES.transformationVersion_1_1_0_JBPAPP_9314();
            }
        }, new String[]{"virtual-server"})).setValueConverter((AttributeConverter)new AttributeConverter.DefaultAttributeConverter(){

            protected void convertAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
                if (!attributeValue.isDefined()) {
                    attributeValue.set(443);
                }
            }
        }, new String[]{WebConnectorDefinition.REDIRECT_PORT.getName()})).end().addOperationTransformationOverride("undefine-attribute").inheritResourceAttributeDefinitions().setCustomOperationTransformer(new OperationTransformer(){

            public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation) throws OperationFailedException {
                String attributeName = operation.require("name").asString();
                if (WebConnectorDefinition.REDIRECT_PORT.getName().equals(attributeName)) {
                    ModelNode transformed = new ModelNode();
                    transformed.get("operation").set("write-attribute");
                    transformed.get("address").set(address.toModelNode());
                    transformed.get("name").set(attributeName);
                    transformed.get("value").set(443);
                    return new OperationTransformer.TransformedOperation(transformed, OperationResultTransformer.ORIGINAL_RESULT);
                }
                return new OperationTransformer.TransformedOperation(operation, OperationResultTransformer.ORIGINAL_RESULT);
            }
        });
        ((AttributeTransformationDescriptionBuilder)connectorBuilder.addChildRedirection(SSL_PATH, SSL_ALIAS).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, (AttributeDefinition[])WebSSLDefinition.SSL_ATTRIBUTES)).end();
        ResourceTransformationDescriptionBuilder hostBuilder = ((AttributeTransformationDescriptionBuilder)subsystemRoot.addChildResource(HOST_PATH).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new AttributeDefinition[]{WebVirtualHostDefinition.DEFAULT_WEB_MODULE})).end();
        ResourceTransformationDescriptionBuilder rewriteBuilder = ((AttributeTransformationDescriptionBuilder)hostBuilder.addChildResource(REWRITE_PATH).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new AttributeDefinition[]{WebReWriteDefinition.FLAGS, WebReWriteDefinition.PATTERN, WebReWriteDefinition.SUBSTITUTION})).end();
        rewriteBuilder.addChildResource(REWRITECOND_PATH).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, (AttributeDefinition[])WebReWriteConditionDefinition.ATTRIBUTES);
        ((AttributeTransformationDescriptionBuilder)hostBuilder.addChildRedirection(SSO_PATH, SSO_ALIAS).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, (AttributeDefinition[])WebSSODefinition.SSO_ATTRIBUTES)).end();
        ResourceTransformationDescriptionBuilder accessLogBuilder = ((AttributeTransformationDescriptionBuilder)hostBuilder.addChildRedirection(ACCESS_LOG_PATH, ACCESS_LOG_ALIAS).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, (AttributeDefinition[])WebAccessLogDefinition.ACCESS_LOG_ATTRIBUTES)).end();
        accessLogBuilder.addChildRedirection(DIRECTORY_PATH, DIRECTORY_ALIAS);
        TransformationDescription.Tools.register((TransformationDescription)subsystemRoot.build(), (SubsystemRegistration)registration, (ModelVersionRange)ModelVersion.create((int)1, (int)1, (int)0));
    }

    private static class StandardWebExtensionAliasEntry
    extends AliasEntry {
        public StandardWebExtensionAliasEntry(ManagementResourceRegistration target) {
            super(target);
        }

        public PathAddress convertToTargetAddress(PathAddress addr) {
            PathAddress targetAddress = this.getTargetAddress();
            ArrayList<PathElement> list = new ArrayList<PathElement>();
            int i = 0;
            for (PathElement element : addr) {
                String key = element.getKey();
                try {
                    if (i < targetAddress.size() && (key.equals("ssl") || key.equals("sso") || key.equals("access-log") || key.equals("directory"))) {
                        list.add(targetAddress.getElement(i));
                    } else {
                        list.add(element);
                    }
                    ++i;
                }
                catch (Exception e) {
                    throw new RuntimeException("Bad " + addr + " " + targetAddress);
                }
            }
            return PathAddress.pathAddress(list);
        }
    }
}

