/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.catalina.Context;
import org.apache.catalina.session.ManagerBase;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.web.WebExtension;
import org.jboss.as.web.WebMessages;
import org.jboss.as.web.WebSubsystemServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;

public class WebDeploymentDefinition
extends SimpleResourceDefinition {
    public static final WebDeploymentDefinition INSTANCE = new WebDeploymentDefinition();
    public static final AttributeDefinition CONTEXT_ROOT = new SimpleAttributeDefinitionBuilder("context-root", ModelType.STRING).setStorageRuntime().build();
    public static final AttributeDefinition VIRTUAL_HOST = new SimpleAttributeDefinitionBuilder("virtual-host", ModelType.STRING).setStorageRuntime().build();

    private WebDeploymentDefinition() {
        super(PathElement.pathElement((String)"subsystem", (String)"web"), (ResourceDescriptionResolver)WebExtension.getResourceDescriptionResolver("deployment"));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadOnlyAttribute(CONTEXT_ROOT, null);
        resourceRegistration.registerReadOnlyAttribute(VIRTUAL_HOST, null);
        for (SessionStat stat : SessionStat.values()) {
            resourceRegistration.registerMetric(stat.definition, (OperationStepHandler)SessionManagerStatsHandler.getInstance());
        }
    }

    public static enum SessionStat {
        ACTIVE_SESSIONS((AttributeDefinition)new SimpleAttributeDefinition("active-sessions", ModelType.INT, false)),
        EXPIRED_SESSIONS((AttributeDefinition)new SimpleAttributeDefinition("expired-sessions", ModelType.INT, false)),
        SESSIONS_CREATED((AttributeDefinition)new SimpleAttributeDefinition("sessions-created", ModelType.INT, false)),
        DUPLICATED_SESSION_IDS((AttributeDefinition)new SimpleAttributeDefinition("duplicated-session-ids", ModelType.INT, false)),
        SESSION_AVG_ALIVE_TIME((AttributeDefinition)new SimpleAttributeDefinition("session-avg-alive-time", ModelType.INT, false)),
        SESSION_MAX_ALIVE_TIME((AttributeDefinition)new SimpleAttributeDefinition("session-max-alive-time", ModelType.INT, false)),
        REJECTED_SESSIONS((AttributeDefinition)new SimpleAttributeDefinition("rejected-sessions", ModelType.INT, false)),
        MAX_ACTIVE_SESSIONS((AttributeDefinition)new SimpleAttributeDefinition("max-active-sessions", ModelType.INT, false));

        private static final Map<String, SessionStat> MAP;
        final AttributeDefinition definition;

        private SessionStat(AttributeDefinition definition) {
            this.definition = definition;
        }

        public final String toString() {
            return this.definition.getName();
        }

        public static synchronized SessionStat getStat(String stringForm) {
            return MAP.get(stringForm);
        }

        static {
            MAP = new HashMap<String, SessionStat>();
            for (SessionStat stat : EnumSet.allOf(SessionStat.class)) {
                MAP.put(stat.toString(), stat);
            }
        }
    }

    static class SessionManagerStatsHandler
    extends AbstractRuntimeOnlyHandler {
        static SessionManagerStatsHandler INSTANCE = new SessionManagerStatsHandler();

        private SessionManagerStatsHandler() {
        }

        public static SessionManagerStatsHandler getInstance() {
            return INSTANCE;
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
            Resource web = context.readResourceFromRoot(address.subAddress(0, address.size()), false);
            ModelNode subModel = web.getModel();
            String host = VIRTUAL_HOST.resolveModelAttribute(context, subModel).asString();
            String path = CONTEXT_ROOT.resolveModelAttribute(context, subModel).asString();
            ServiceController controller = context.getServiceRegistry(false).getService(WebSubsystemServices.deploymentServiceName(host, path));
            SessionStat stat = SessionStat.getStat(operation.require("name").asString());
            if (stat == null) {
                context.getFailureDescription().set(WebMessages.MESSAGES.unknownMetric(operation.require("name").asString()));
            } else {
                Context webContext = (Context)Context.class.cast(controller.getValue());
                ManagerBase sm = (ManagerBase)webContext.getManager();
                ModelNode result = new ModelNode();
                switch (stat) {
                    case ACTIVE_SESSIONS: {
                        result.set(sm.getActiveSessions());
                        break;
                    }
                    case EXPIRED_SESSIONS: {
                        result.set(sm.getExpiredSessions());
                        break;
                    }
                    case MAX_ACTIVE_SESSIONS: {
                        result.set(sm.getMaxActive());
                        break;
                    }
                    case SESSIONS_CREATED: {
                        result.set(sm.getSessionCounter());
                        break;
                    }
                    case DUPLICATED_SESSION_IDS: {
                        result.set(sm.getDuplicates());
                        break;
                    }
                    case SESSION_AVG_ALIVE_TIME: {
                        result.set(sm.getSessionAverageAliveTime());
                        break;
                    }
                    case SESSION_MAX_ALIVE_TIME: {
                        result.set(sm.getSessionMaxAliveTime());
                        break;
                    }
                    case REJECTED_SESSIONS: {
                        result.set(sm.getRejectedSessions());
                        break;
                    }
                    default: {
                        throw new IllegalStateException(WebMessages.MESSAGES.unknownMetric((Object)stat));
                    }
                }
                context.getResult().set(result);
            }
            context.stepCompleted();
        }
    }
}

