/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.moduleservice;

import java.io.File;
import org.jboss.as.server.Services;
import org.jboss.as.server.moduleservice.ExternalModuleSpecService;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class ExternalModuleService
implements Service<ExternalModuleService> {
    public static String EXTERNAL_MODULE_PREFIX = "deployment.external.";
    private volatile ServiceContainer serviceContainer;

    public ModuleIdentifier addExternalModule(String externalModule) {
        ModuleIdentifier identifier = ModuleIdentifier.create((String)(EXTERNAL_MODULE_PREFIX + externalModule));
        ServiceName serviceName = ServiceModuleLoader.moduleSpecServiceName(identifier);
        ServiceController controller = this.serviceContainer.getService(serviceName);
        if (controller == null) {
            ExternalModuleSpecService service = new ExternalModuleSpecService(identifier, new File(externalModule));
            this.serviceContainer.addService(serviceName, (Service)service).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        }
        return identifier;
    }

    public void start(StartContext context) throws StartException {
        if (this.serviceContainer != null) {
            throw new IllegalStateException("External Module Service already started");
        }
        this.serviceContainer = context.getController().getServiceContainer();
    }

    public void stop(StopContext context) {
        this.serviceContainer = null;
    }

    public ExternalModuleService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public static void addService(ServiceTarget serviceTarget) {
        ExternalModuleService service = new ExternalModuleService();
        ServiceBuilder serviceBuilder = serviceTarget.addService(Services.JBOSS_EXTERNAL_MODULE_SERVICE, (Service)service);
        serviceBuilder.install();
    }
}

