/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.remoting.AbstractOutboundConnectionAddHandler;
import org.jboss.as.remoting.AbstractOutboundConnectionService;
import org.jboss.as.remoting.ConnectorResource;
import org.jboss.as.remoting.GenericOutboundConnectionResourceDefinition;
import org.jboss.as.remoting.GenericOutboundConnectionService;
import org.jboss.as.remoting.RemotingMessages;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.remoting3.Endpoint;
import org.xnio.OptionMap;

class GenericOutboundConnectionAdd
extends AbstractOutboundConnectionAddHandler {
    static final GenericOutboundConnectionAdd INSTANCE = new GenericOutboundConnectionAdd();

    static ModelNode getAddOperation(String connectionName, String uri, PathAddress address) {
        if (connectionName == null || connectionName.trim().isEmpty()) {
            throw RemotingMessages.MESSAGES.connectionNameEmpty();
        }
        if (uri == null || uri.trim().isEmpty()) {
            throw RemotingMessages.MESSAGES.connectionUriEmpty(connectionName);
        }
        ModelNode addOperation = new ModelNode();
        addOperation.get("operation").set("add");
        addOperation.get("address").set(address.toModelNode());
        addOperation.get("uri").set(uri);
        return addOperation;
    }

    private GenericOutboundConnectionAdd() {
    }

    @Override
    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        super.populateModel(operation, model);
        GenericOutboundConnectionResourceDefinition.URI.validateAndSet(operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ModelNode fullModel = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        ServiceController serviceController = this.installRuntimeService(context, operation, fullModel, verificationHandler);
        newControllers.add(serviceController);
    }

    ServiceController installRuntimeService(OperationContext context, ModelNode operation, ModelNode fullModel, ServiceVerificationHandler verificationHandler) throws OperationFailedException {
        PathAddress pathAddress = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String connectionName = pathAddress.getLastElement().getValue();
        OptionMap connectionCreationOptions = ConnectorResource.getOptions(context, fullModel.get("property"));
        URI uri = this.getDestinationURI(context, operation);
        GenericOutboundConnectionService outboundRemotingConnectionService = new GenericOutboundConnectionService(connectionName, uri, connectionCreationOptions);
        ServiceName serviceName = AbstractOutboundConnectionService.OUTBOUND_CONNECTION_BASE_SERVICE_NAME.append(new String[]{connectionName});
        ServiceName aliasServiceName = GenericOutboundConnectionService.GENERIC_OUTBOUND_CONNECTION_BASE_SERVICE_NAME.append(new String[]{connectionName});
        ServiceBuilder svcBuilder = context.getServiceTarget().addService(serviceName, (Service)outboundRemotingConnectionService).addAliases(new ServiceName[]{aliasServiceName}).addDependency(RemotingServices.SUBSYSTEM_ENDPOINT, Endpoint.class, outboundRemotingConnectionService.getEndpointInjector());
        if (verificationHandler != null) {
            svcBuilder.addListener((ServiceListener)verificationHandler);
        }
        return svcBuilder.install();
    }

    URI getDestinationURI(OperationContext context, ModelNode outboundConnection) throws OperationFailedException {
        String uri = GenericOutboundConnectionResourceDefinition.URI.resolveModelAttribute(context, outboundConnection).asString();
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw RemotingMessages.MESSAGES.couldNotCreateURI(uri, e.toString());
        }
    }
}

