/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.proxy;

import java.lang.reflect.Method;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.proxy.Interceptor;
import org.jboss.arquillian.graphene.proxy.InvocationContext;

public class InvocationContextImpl
implements InvocationContext {
    private final InvocationContext following;
    private final Interceptor interceptor;
    private final Object target;
    private final Object proxy;
    private final Method method;
    private final Object[] arguments;
    private final GrapheneContext context;

    public InvocationContextImpl(GrapheneContext context, Object target, Object proxy, Method method, Object[] arguments) {
        if (target == null) {
            throw new IllegalArgumentException("The parameter [target] is null.");
        }
        if (proxy == null) {
            throw new IllegalArgumentException("The parameter [proxy] is null.");
        }
        if (method == null) {
            throw new IllegalArgumentException("The parameter [method] is null.");
        }
        if (arguments == null) {
            throw new IllegalArgumentException("The parameter [arguments] is null.");
        }
        if (context == null) {
            throw new IllegalArgumentException("The parameter [context] is null.");
        }
        this.following = null;
        this.interceptor = null;
        this.arguments = arguments;
        this.method = method;
        this.target = target;
        this.context = context;
        this.proxy = proxy;
    }

    public InvocationContextImpl(Interceptor interceptor, InvocationContext following) {
        if (following == null) {
            throw new IllegalArgumentException("The parameter [following] is null.");
        }
        if (interceptor == null) {
            throw new IllegalArgumentException("The parameter [interceptor] is null.");
        }
        this.following = following;
        this.interceptor = interceptor;
        this.arguments = null;
        this.method = null;
        this.target = null;
        this.context = null;
        this.proxy = null;
    }

    @Override
    public Object invoke() throws Throwable {
        if (this.following == null) {
            return this.method.invoke(this.target, this.arguments);
        }
        return this.interceptor.intercept(this.following);
    }

    @Override
    public Method getMethod() {
        return this.method == null ? this.following.getMethod() : this.method;
    }

    @Override
    public Object[] getArguments() {
        return this.arguments == null ? this.following.getArguments() : this.arguments;
    }

    @Override
    public Object getTarget() {
        return this.target == null ? this.following.getTarget() : this.target;
    }

    @Override
    public Object getProxy() {
        return this.proxy == null ? this.following.getProxy() : this.proxy;
    }

    @Override
    public GrapheneContext getGrapheneContext() {
        return this.context == null ? this.following.getGrapheneContext() : this.context;
    }
}

