/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.enricher;

import java.lang.reflect.Method;
import org.jboss.arquillian.graphene.enricher.WebElementUtils;
import org.jboss.arquillian.graphene.proxy.GrapheneProxy;
import org.jboss.arquillian.graphene.proxy.Interceptor;
import org.jboss.arquillian.graphene.proxy.InvocationContext;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;

public class SearchContextInterceptor
implements Interceptor {
    @Override
    public Object intercept(final InvocationContext context) throws Throwable {
        GrapheneProxy.FutureTarget future = new GrapheneProxy.FutureTarget(){

            @Override
            public Object getTarget() {
                return context.getProxy();
            }
        };
        if (SearchContextInterceptor.methodsEqual(context.getMethod(), SearchContext.class.getDeclaredMethod("findElement", By.class))) {
            return WebElementUtils.findElement(context.getGrapheneContext(), (By)context.getArguments()[0], future);
        }
        if (SearchContextInterceptor.methodsEqual(context.getMethod(), SearchContext.class.getDeclaredMethod("findElements", By.class))) {
            return WebElementUtils.findElementsLazily(context.getGrapheneContext(), (By)context.getArguments()[0], future);
        }
        return context.invoke();
    }

    protected static boolean methodsEqual(Method first, Method second) {
        if (first == second) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        if (!first.getName().equals(second.getName())) {
            return false;
        }
        if (first.getParameterTypes().length != second.getParameterTypes().length) {
            return false;
        }
        for (int i = 0; i < first.getParameterTypes().length; ++i) {
            if (first.getParameterTypes()[i].equals(second.getParameterTypes()[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getPrecedence() {
        return 0;
    }
}

