/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.se.server;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

final class SecurityActions {
    private SecurityActions() {
    }

    static ClassLoader getClassLoader(final Class<?> javaClass) {
        if (System.getSecurityManager() == null) {
            return javaClass.getClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return javaClass.getClassLoader();
            }
        });
    }

    static <T> T newInstance(final Class<T> javaClass) throws InstantiationException, IllegalAccessException, PrivilegedActionException {
        if (System.getSecurityManager() == null) {
            return javaClass.newInstance();
        }
        return AccessController.doPrivileged(new PrivilegedExceptionAction<T>(){

            @Override
            public T run() throws Exception {
                return javaClass.newInstance();
            }
        });
    }
}

