/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.weld.ee.embedded_1_1.mock;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.ejb.Local;
import javax.ejb.MessageDriven;
import javax.ejb.Remote;
import javax.ejb.Remove;
import javax.ejb.Singleton;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import org.jboss.weld.ejb.spi.BusinessInterfaceDescriptor;
import org.jboss.weld.ejb.spi.EjbDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockEjbDescriptor<T>
implements EjbDescriptor<T> {
    private final Class<T> beanClass;
    private final String ejbName;
    private final List<BusinessInterfaceDescriptor<?>> localInterfaces;
    private final List<BusinessInterfaceDescriptor<?>> remoteInterfaces;
    private final HashSet<Method> removeMethods;

    public static <T> MockEjbDescriptor<T> of(Class<T> type) {
        return new MockEjbDescriptor<T>(type);
    }

    /*
     * WARNING - void declaration
     */
    private MockEjbDescriptor(Class<T> type) {
        void var6_16;
        void var6_14;
        int len$;
        this.beanClass = type;
        this.ejbName = type.getSimpleName();
        this.localInterfaces = new ArrayList();
        Local localAnnotation = type.getAnnotation(Local.class);
        if (localAnnotation != null) {
            for (Class clazz : localAnnotation.value()) {
                this.localInterfaces.add(this.createBusinessInterfaceDescriptor(clazz));
            }
        }
        for (Class clazz : type.getInterfaces()) {
            if (!clazz.isAnnotationPresent(Local.class)) continue;
            this.localInterfaces.add(this.createBusinessInterfaceDescriptor(clazz));
        }
        this.remoteInterfaces = new ArrayList();
        Remote remoteAnnotation = type.getAnnotation(Remote.class);
        if (remoteAnnotation != null) {
            void var6_12;
            Class[] arr$ = remoteAnnotation.value();
            len$ = arr$.length;
            boolean bl = false;
            while (var6_12 < len$) {
                Class clazz = arr$[var6_12];
                this.remoteInterfaces.add(this.createBusinessInterfaceDescriptor(clazz));
                ++var6_12;
            }
        }
        GenericDeclaration[] arr$ = type.getInterfaces();
        len$ = arr$.length;
        boolean bl = false;
        while (var6_14 < len$) {
            Class<?> clazz = arr$[var6_14];
            if (clazz.isAnnotationPresent(Remote.class)) {
                this.remoteInterfaces.add(this.createBusinessInterfaceDescriptor(clazz));
            }
            ++var6_14;
        }
        if (this.localInterfaces.size() == 0) {
            this.localInterfaces.add(this.createBusinessInterfaceDescriptor(type));
        }
        this.removeMethods = new HashSet();
        arr$ = type.getMethods();
        len$ = arr$.length;
        boolean bl2 = false;
        while (var6_16 < len$) {
            GenericDeclaration genericDeclaration = arr$[var6_16];
            if (((AccessibleObject)((Object)genericDeclaration)).isAnnotationPresent(Remove.class)) {
                this.removeMethods.add((Method)genericDeclaration);
            }
            ++var6_16;
        }
    }

    private BusinessInterfaceDescriptor<Object> createBusinessInterfaceDescriptor(final Class<?> clazz) {
        return new BusinessInterfaceDescriptor<Object>(){

            public Class<Object> getInterface() {
                return clazz;
            }
        };
    }

    public String getEjbName() {
        return this.ejbName;
    }

    public Collection<BusinessInterfaceDescriptor<?>> getLocalBusinessInterfaces() {
        return this.localInterfaces;
    }

    public Collection<BusinessInterfaceDescriptor<?>> getRemoteBusinessInterfaces() {
        return this.remoteInterfaces;
    }

    public Collection<Method> getRemoveMethods() {
        return this.removeMethods;
    }

    public Class<T> getBeanClass() {
        return this.beanClass;
    }

    public boolean isMessageDriven() {
        return this.beanClass.isAnnotationPresent(MessageDriven.class);
    }

    public boolean isSingleton() {
        return this.beanClass.isAnnotationPresent(Singleton.class);
    }

    public boolean isStateful() {
        return this.beanClass.isAnnotationPresent(Stateful.class);
    }

    public boolean isStateless() {
        return this.beanClass.isAnnotationPresent(Stateless.class);
    }

    public String getLocalJndiName() {
        return this.beanClass.getSimpleName() + "/local";
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getEjbName());
        if (this.isStateful()) {
            builder.append(" (SFSB)");
        }
        if (this.isStateless()) {
            builder.append(" (SLSB)");
        }
        if (this.isSingleton()) {
            builder.append(" (Singleton)");
        }
        if (this.isMessageDriven()) {
            builder.append(" (MDB)");
        }
        builder.append("remove methods; " + this.removeMethods + "; ");
        builder.append("; BeanClass: " + this.getBeanClass() + "; Local Business Interfaces: " + this.getLocalBusinessInterfaces());
        return builder.toString();
    }
}

