/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.weld.ee.embedded_1_1;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.jboss.arquillian.core.spi.Validate;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.ArchiveAsset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Utils {
    private Utils() {
    }

    static <T> T getBeanReference(BeanManager manager, Class<T> type) {
        Bean bean = manager.resolve(manager.getBeans(type, new Annotation[0]));
        return (T)manager.getReference(bean, type, manager.createCreationalContext(null));
    }

    public static String findArchiveId(Archive<?> archive) {
        return archive.getName();
    }

    public static Collection<URL> findBeansXml(Archive<?> archive) {
        Validate.notNull(archive, (String)"Archive must be specified");
        ArrayList<URL> beansXmls = new ArrayList<URL>();
        Map nestedArchives = archive.getContent(Filters.include((String)".*\\.jar|.*\\.war"));
        for (Map.Entry nestedArchiveEntry : nestedArchives.entrySet()) {
            if (!(((Node)nestedArchiveEntry.getValue()).getAsset() instanceof ArchiveAsset)) continue;
            ArchiveAsset nestedArchive = (ArchiveAsset)((Node)nestedArchiveEntry.getValue()).getAsset();
            Map classes = nestedArchive.getArchive().getContent(Filters.include((String)".*/beans.xml"));
            for (final Map.Entry entry : classes.entrySet()) {
                try {
                    beansXmls.add(new URL(null, "archive://" + ((ArchivePath)entry.getKey()).get(), new URLStreamHandler(){

                        protected URLConnection openConnection(URL u) throws IOException {
                            return new URLConnection(u){

                                public void connect() throws IOException {
                                }

                                public InputStream getInputStream() throws IOException {
                                    return ((Node)entry.getValue()).getAsset().openStream();
                                }
                            };
                        }
                    }));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        Map classes = archive.getContent(Filters.include((String)".*/beans.xml"));
        for (final Map.Entry entry : classes.entrySet()) {
            try {
                beansXmls.add(new URL(null, "archive://" + ((ArchivePath)entry.getKey()).get(), new URLStreamHandler(){

                    protected URLConnection openConnection(URL u) throws IOException {
                        return new URLConnection(u){

                            public void connect() throws IOException {
                            }

                            public InputStream getInputStream() throws IOException {
                                return ((Node)entry.getValue()).getAsset().openStream();
                            }
                        };
                    }
                }));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return beansXmls;
    }

    public static Collection<Class<?>> findBeanClasses(Archive<?> archive, ClassLoader classLoader) {
        Validate.notNull(archive, (String)"Archive must be specified");
        ArrayList beanClasses = new ArrayList();
        try {
            Map nestedArchives = archive.getContent(Filters.include((String)".*\\.jar|.*\\.war|.*\\.rar"));
            for (Map.Entry nestedArchiveEntry : nestedArchives.entrySet()) {
                if (!(((Node)nestedArchiveEntry.getValue()).getAsset() instanceof ArchiveAsset)) continue;
                ArchiveAsset nestedArchive = (ArchiveAsset)((Node)nestedArchiveEntry.getValue()).getAsset();
                Map classes = nestedArchive.getArchive().getContent(Filters.include((String)".*\\.class"));
                for (Map.Entry classEntry : classes.entrySet()) {
                    Class<?> loadedClass = classLoader.loadClass(Utils.findClassName((ArchivePath)classEntry.getKey()));
                    beanClasses.add(loadedClass);
                }
            }
            Map classes = archive.getContent(Filters.include((String)".*\\.class"));
            for (Map.Entry classEntry : classes.entrySet()) {
                Class<?> loadedClass = classLoader.loadClass(Utils.findClassName((ArchivePath)classEntry.getKey()));
                beanClasses.add(loadedClass);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not load class from archive " + archive.getName(), e);
        }
        return beanClasses;
    }

    public static String findClassName(ArchivePath path) {
        String className = path.get();
        if ((className = className.replaceAll("/WEB-INF/classes/", "")).charAt(0) == '/') {
            className = className.substring(1);
        }
        className = className.replaceAll("\\.class", "");
        className = className.replaceAll("/", ".");
        return className;
    }
}

