/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.mojo;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.javacc.mojo.AbstractPreprocessorMojo;
import org.javacc.mojo.GrammarInfo;
import org.javacc.mojo.JJTree;

public class JJTreeMojo
extends AbstractPreprocessorMojo {
    private String jdkVersion;
    private Boolean buildNodeFiles;
    private Boolean multi;
    private Boolean nodeDefaultVoid;
    private String nodeClass;
    private String nodeFactory;
    private String nodePackage;
    private String nodePrefix;
    private Boolean nodeScopeHook;
    private Boolean nodeUsesParser;
    private Boolean isStatic;
    private Boolean trackTokens;
    private Boolean visitor;
    private String visitorDataType;
    private String visitorReturnType;
    private String visitorException;
    private File sourceDirectory;
    private File outputDirectory;
    private File timestampDirectory;
    private int staleMillis;
    private String[] includes;
    private String[] excludes;

    @Override
    protected File getSourceDirectory() {
        return this.sourceDirectory;
    }

    @Override
    protected String[] getIncludes() {
        if (this.includes != null) {
            return this.includes;
        }
        return new String[]{"**/*.jjt", "**/*.JJT"};
    }

    @Override
    protected String[] getExcludes() {
        return this.excludes;
    }

    @Override
    protected File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    protected File getTimestampDirectory() {
        return this.timestampDirectory;
    }

    @Override
    protected int getStaleMillis() {
        return this.staleMillis;
    }

    @Override
    protected void processGrammar(GrammarInfo grammarInfo) throws MojoExecutionException, MojoFailureException {
        File jjtFile = grammarInfo.getGrammarFile();
        String nodePackageName = grammarInfo.resolvePackageName(this.nodePackage);
        File nodeDirectory = nodePackageName != null ? new File(nodePackageName.replace('.', File.separatorChar)) : new File(grammarInfo.getParserDirectory());
        nodeDirectory = new File(this.getOutputDirectory(), nodeDirectory.getPath());
        JJTree jjtree = this.newJJTree();
        jjtree.setInputFile(jjtFile);
        jjtree.setOutputDirectory(nodeDirectory);
        jjtree.setNodePackage(nodePackageName);
        jjtree.run();
        this.createTimestamp(grammarInfo);
    }

    protected JJTree newJJTree() {
        JJTree jjtree = new JJTree();
        jjtree.setLog(this.getLog());
        jjtree.setJdkVersion(this.jdkVersion);
        jjtree.setStatic(this.isStatic);
        jjtree.setBuildNodeFiles(this.buildNodeFiles);
        jjtree.setMulti(this.multi);
        jjtree.setNodeDefaultVoid(this.nodeDefaultVoid);
        jjtree.setNodeClass(this.nodeClass);
        jjtree.setNodeFactory(this.nodeFactory);
        jjtree.setNodePrefix(this.nodePrefix);
        jjtree.setNodeScopeHook(this.nodeScopeHook);
        jjtree.setNodeUsesParser(this.nodeUsesParser);
        jjtree.setTrackTokens(this.trackTokens);
        jjtree.setVisitor(this.visitor);
        jjtree.setVisitorDataType(this.visitorDataType);
        jjtree.setVisitorReturnType(this.visitorReturnType);
        jjtree.setVisitorException(this.visitorException);
        return jjtree;
    }

    @Override
    protected void addCompileSourceRoot() {
    }
}

