/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.server.configuration.InterfaceConfiguration;
import org.infinispan.server.configuration.InterfaceConfigurationBuilder;
import org.infinispan.server.configuration.InterfacesConfiguration;
import org.infinispan.server.network.NetworkAddress;

public class InterfacesConfigurationBuilder
implements Builder<InterfacesConfiguration> {
    private final Map<String, InterfaceConfigurationBuilder> interfaces = new HashMap<String, InterfaceConfigurationBuilder>(2);

    InterfaceConfigurationBuilder addInterface(String name) {
        InterfaceConfigurationBuilder interfaceConfigurationBuilder = new InterfaceConfigurationBuilder(name);
        this.interfaces.put(name, interfaceConfigurationBuilder);
        return interfaceConfigurationBuilder;
    }

    NetworkAddress getNetworkAddress(String interfaceName) {
        return this.interfaces.get(interfaceName).networkAddress();
    }

    public InterfacesConfiguration create() {
        List<InterfaceConfiguration> configurations = this.interfaces.values().stream().map(InterfaceConfigurationBuilder::create).collect(Collectors.toList());
        return new InterfacesConfiguration(configurations);
    }

    public InterfacesConfigurationBuilder read(InterfacesConfiguration template) {
        this.interfaces.clear();
        template.interfaces().forEach(i -> this.addInterface(i.name()).read((InterfaceConfiguration)i));
        return this;
    }

    public void validate() {
    }

    boolean exists(String interfaceName) {
        return this.interfaces.containsKey(interfaceName);
    }
}

