/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.tx.table;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.Immutable;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.time.TimeService;
import org.infinispan.remoting.transport.Address;
import org.infinispan.server.hotrod.tx.table.ClientAddress;
import org.infinispan.server.hotrod.tx.table.Status;
import org.infinispan.transaction.xa.GlobalTransaction;

@Immutable
public class TxState {
    public static final AdvancedExternalizer<TxState> EXTERNALIZER = new Externalizer();
    private final GlobalTransaction globalTransaction;
    private final Status status;
    private final List<WriteCommand> modifications;
    private final boolean recoverable;
    private final long timeout;
    private final long lastAccessTimeNs;

    public TxState(GlobalTransaction globalTransaction, boolean recoverable, long timeout, TimeService timeService) {
        this(globalTransaction, Status.ACTIVE, null, recoverable, timeout, timeService.time());
    }

    private TxState(GlobalTransaction globalTransaction, Status status, List<WriteCommand> modifications, boolean recoverable, long timeout, long accessTime) {
        this.globalTransaction = Objects.requireNonNull(globalTransaction);
        this.status = Objects.requireNonNull(status);
        this.modifications = modifications == null ? null : Collections.unmodifiableList(modifications);
        this.recoverable = recoverable;
        this.timeout = timeout;
        this.lastAccessTimeNs = accessTime;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public TxState markPreparing(List<WriteCommand> modifications, TimeService timeService) {
        return new TxState(this.globalTransaction, Status.PREPARING, modifications, this.recoverable, this.timeout, timeService.time());
    }

    public Address getOriginator() {
        return ((ClientAddress)this.globalTransaction.getAddress()).getLocalAddress();
    }

    public TxState setStatus(Status newStatus, boolean cleanupModification, TimeService timeService) {
        return new TxState(this.globalTransaction, newStatus, cleanupModification ? null : this.modifications, this.recoverable, this.timeout, timeService.time());
    }

    public Status getStatus() {
        return this.status;
    }

    public GlobalTransaction getGlobalTransaction() {
        return this.globalTransaction;
    }

    public List<WriteCommand> getModifications() {
        return this.modifications;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TxState txState = (TxState)o;
        return Objects.equals((Object)this.status, (Object)txState.status) && Objects.equals(this.globalTransaction, txState.globalTransaction);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.globalTransaction);
        result = 31 * result + Objects.hashCode((Object)this.status);
        return result;
    }

    public boolean hasTimedOut(long currentTimeNs) {
        long timeoutNs = TimeUnit.MILLISECONDS.toNanos(this.timeout);
        return this.lastAccessTimeNs + timeoutNs < currentTimeNs;
    }

    public boolean isRecoverable() {
        return this.recoverable;
    }

    public String toString() {
        return "TxState{globalTransaction=" + this.globalTransaction + ", status=" + (Object)((Object)this.status) + ", modifications=" + this.modifications + ", recoverable=" + this.recoverable + ", timeout=" + this.timeout + ", lastAccessTime=" + this.lastAccessTimeNs + '}';
    }

    private static class Externalizer
    implements AdvancedExternalizer<TxState> {
        private Externalizer() {
        }

        public Set<Class<? extends TxState>> getTypeClasses() {
            return Collections.singleton(TxState.class);
        }

        public Integer getId() {
            return 1113;
        }

        public void writeObject(ObjectOutput output, TxState object) throws IOException {
            output.writeObject(object.globalTransaction);
            Status.writeTo(output, object.status);
            MarshallUtil.marshallCollection((Collection)object.modifications, (ObjectOutput)output);
            output.writeBoolean(object.recoverable);
            output.writeLong(object.timeout);
            output.writeLong(object.lastAccessTimeNs);
        }

        public TxState readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new TxState((GlobalTransaction)input.readObject(), Status.readFrom(input), (List)MarshallUtil.unmarshallCollection((ObjectInput)input, ArrayList::new), input.readBoolean(), input.readLong(), input.readLong());
        }
    }
}

