/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.CompletionStage;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listenable;
import org.infinispan.security.Security;
import org.infinispan.security.actions.AddCacheManagerListenerAction;
import org.infinispan.security.actions.GetCacheAction;
import org.infinispan.security.actions.GetCacheComponentRegistryAction;
import org.infinispan.security.actions.GetCacheConfigurationAction;
import org.infinispan.security.actions.GetCacheManagerConfigurationAction;
import org.infinispan.security.actions.GetGlobalComponentRegistryAction;
import org.infinispan.security.actions.RemoveListenerAsyncAction;
import org.infinispan.security.impl.SecureCacheImpl;

final class SecurityActions {
    SecurityActions() {
    }

    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(action);
        }
        return (T)Security.doPrivileged(action);
    }

    static ComponentRegistry getCacheComponentRegistry(AdvancedCache<?, ?> cache) {
        GetCacheComponentRegistryAction action = new GetCacheComponentRegistryAction(cache);
        return (ComponentRegistry)SecurityActions.doPrivileged(action);
    }

    static Configuration getCacheConfiguration(AdvancedCache<?, ?> cache) {
        GetCacheConfigurationAction action = new GetCacheConfigurationAction(cache);
        return (Configuration)SecurityActions.doPrivileged(action);
    }

    static DistributionManager getDistributionManager(AdvancedCache<?, ?> cache) {
        return SecurityActions.doPrivileged(() -> cache.getDistributionManager());
    }

    static <K, V> Cache<K, V> getCache(EmbeddedCacheManager cacheManager, String cacheName) {
        GetCacheAction action = new GetCacheAction(cacheManager, cacheName);
        return (Cache)SecurityActions.doPrivileged(action);
    }

    static GlobalComponentRegistry getGlobalComponentRegistry(EmbeddedCacheManager cacheManager) {
        GetGlobalComponentRegistryAction action = new GetGlobalComponentRegistryAction(cacheManager);
        return (GlobalComponentRegistry)SecurityActions.doPrivileged(action);
    }

    static GlobalConfiguration getCacheManagerConfiguration(EmbeddedCacheManager cacheManager) {
        return (GlobalConfiguration)SecurityActions.doPrivileged(new GetCacheManagerConfigurationAction(cacheManager));
    }

    static void addListener(EmbeddedCacheManager cacheManager, Object listener) {
        SecurityActions.doPrivileged(new AddCacheManagerListenerAction(cacheManager, listener));
    }

    static CompletionStage<Void> removeListenerAsync(Listenable listenable, Object listener) {
        RemoveListenerAsyncAction action = new RemoveListenerAsyncAction(listenable, listener);
        return (CompletionStage)SecurityActions.doPrivileged(action);
    }

    static <K, V> AdvancedCache<K, V> getUnwrappedCache(AdvancedCache<K, V> cache) {
        if (cache instanceof SecureCacheImpl) {
            return SecurityActions.doPrivileged(() -> ((SecureCacheImpl)((SecureCacheImpl)cache)).getDelegate());
        }
        return cache;
    }

    static <K, V> AdvancedCache<K, V> anonymizeSecureCache(AdvancedCache<K, V> cache) {
        return SecurityActions.doPrivileged(() -> cache.transform(SecurityActions::unsetSubject));
    }

    private static <K, V> AdvancedCache<K, V> unsetSubject(AdvancedCache<K, V> cache) {
        if (cache instanceof SecureCacheImpl) {
            return new SecureCacheImpl(SecurityActions.getUnwrappedCache(cache));
        }
        return cache;
    }
}

