/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.NumericVersion;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverter;
import org.infinispan.notifications.cachelistener.filter.EventType;

class KeyValueVersionConverter
implements CacheEventConverter<byte[], byte[], byte[]> {
    private final boolean returnOldValue;
    public static KeyValueVersionConverter EXCLUDING_OLD_VALUE_CONVERTER = new KeyValueVersionConverter(false);
    public static KeyValueVersionConverter INCLUDING_OLD_VALUE_CONVERTER = new KeyValueVersionConverter(true);

    private KeyValueVersionConverter(boolean returnOldValue) {
        this.returnOldValue = returnOldValue;
    }

    public byte[] convert(byte[] key, byte[] oldValue, Metadata oldMetadata, byte[] newValue, Metadata newMetadata, EventType eventType) {
        int capacity = UnsignedNumeric.sizeUnsignedInt((int)key.length) + key.length + (newValue != null ? UnsignedNumeric.sizeUnsignedInt((int)newValue.length) + newValue.length + 8 : 0);
        if (newValue == null && this.returnOldValue && oldValue != null) {
            capacity += UnsignedNumeric.sizeUnsignedInt((int)oldValue.length) + oldValue.length + 8;
        }
        byte[] out = new byte[capacity];
        int offset = UnsignedNumeric.writeUnsignedInt((byte[])out, (int)0, (int)key.length);
        offset += this.putBytes(key, offset, out);
        EntryVersion version = newMetadata.version();
        if (newValue != null) {
            offset += UnsignedNumeric.writeUnsignedInt((byte[])out, (int)offset, (int)newValue.length);
            offset += this.putBytes(newValue, offset, out);
            if (version != null) {
                this.putLong(((NumericVersion)version).getVersion(), offset, out);
            }
        }
        if (newValue == null && this.returnOldValue && oldValue != null) {
            offset += UnsignedNumeric.writeUnsignedInt((byte[])out, (int)offset, (int)oldValue.length);
            offset += this.putBytes(oldValue, offset, out);
            if (version != null) {
                this.putLong(((NumericVersion)version).getVersion(), offset, out);
            }
        }
        return out;
    }

    private int putBytes(byte[] bytes, int offset, byte[] out) {
        System.arraycopy(bytes, 0, out, offset, bytes.length);
        return bytes.length;
    }

    private int putLong(long l, int offset, byte[] out) {
        out[offset] = (byte)(l >> 56);
        out[offset + 1] = (byte)(l >> 48);
        out[offset + 2] = (byte)(l >> 40);
        out[offset + 3] = (byte)(l >> 32);
        out[offset + 4] = (byte)(l >> 24);
        out[offset + 5] = (byte)(l >> 16);
        out[offset + 6] = (byte)(l >> 8);
        out[offset + 7] = (byte)l;
        return offset + 8;
    }

    public boolean useRequestFormat() {
        return true;
    }

    static class Externalizer
    extends AbstractExternalizer<KeyValueVersionConverter> {
        Externalizer() {
        }

        public Set<Class<? extends KeyValueVersionConverter>> getTypeClasses() {
            return Collections.singleton(KeyValueVersionConverter.class);
        }

        public void writeObject(ObjectOutput output, KeyValueVersionConverter object) throws IOException {
            output.writeBoolean(object.returnOldValue);
        }

        public KeyValueVersionConverter readObject(ObjectInput input) throws IOException {
            boolean returnOldValue = input.readBoolean();
            return returnOldValue ? INCLUDING_OLD_VALUE_CONVERTER : EXCLUDING_OLD_VALUE_CONVERTER;
        }
    }
}

