/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.stats.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import org.hibernate.search.backend.lucene.index.LuceneIndexManager;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactory;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.query.Indexer;
import org.infinispan.query.core.stats.IndexInfo;
import org.infinispan.query.core.stats.IndexStatistics;
import org.infinispan.query.core.stats.IndexStatisticsSnapshot;
import org.infinispan.query.core.stats.impl.IndexStatisticsSnapshotImpl;
import org.infinispan.search.mapper.mapping.SearchIndexedEntity;
import org.infinispan.search.mapper.mapping.SearchMapping;
import org.infinispan.search.mapper.scope.SearchScope;
import org.infinispan.search.mapper.session.SearchSession;
import org.infinispan.util.concurrent.AggregateCompletionStage;
import org.infinispan.util.concurrent.BlockingManager;
import org.infinispan.util.concurrent.CompletionStages;

@Scope(value=Scopes.NAMED_CACHE)
public class LocalIndexStatistics
implements IndexStatistics {
    @Inject
    SearchMapping searchMapping;
    @Inject
    BlockingManager blockingManager;
    @Inject
    Indexer indexer;

    public Set<String> indexedEntities() {
        return this.searchMapping.allIndexedEntityNames();
    }

    public CompletionStage<Map<String, IndexInfo>> computeIndexInfos() {
        HashMap<String, CompletionStage<IndexInfo>> infoStages = new HashMap<String, CompletionStage<IndexInfo>>();
        AggregateCompletionStage aggregateCompletionStage = CompletionStages.aggregateCompletionStage(new HashMap());
        for (SearchIndexedEntity searchIndexedEntity : this.searchMapping.allIndexedEntities()) {
            CompletionStage<IndexInfo> stage = this.indexInfos(searchIndexedEntity);
            infoStages.put(searchIndexedEntity.name(), stage);
            aggregateCompletionStage.dependsOn(stage);
        }
        return aggregateCompletionStage.freeze().thenApply(map -> {
            infoStages.forEach((name, stage) -> map.put(name, (IndexInfo)CompletionStages.join((CompletionStage)stage)));
            return map;
        });
    }

    private CompletionStage<IndexInfo> indexInfos(SearchIndexedEntity indexedEntity) {
        SearchSession session = this.searchMapping.getMappingSession();
        SearchScope<?> scope = session.scope(indexedEntity.javaClass(), indexedEntity.name());
        CompletionStage countStage = this.blockingManager.supplyBlocking(() -> session.search(scope).where(SearchPredicateFactory::matchAll).fetchTotalHitCount(), (Object)this);
        CompletionStage sizeStage = ((LuceneIndexManager)indexedEntity.indexManager().unwrap(LuceneIndexManager.class)).computeSizeInBytesAsync();
        return countStage.thenCombine(sizeStage, IndexInfo::new);
    }

    public boolean reindexing() {
        return this.indexer.isRunning();
    }

    public CompletionStage<IndexStatisticsSnapshot> computeSnapshot() {
        return this.computeIndexInfos().thenApply(infos -> new IndexStatisticsSnapshotImpl(infos, this.reindexing()));
    }
}

