/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;

public final class ByteQuantity {
    private static final Pattern REGEX_PATTERN = Pattern.compile("^(\\d*\\.?\\d+)\\s*((?:(?:[KMGT]i?)B)|B)?$");
    private static final BigDecimal KILO = new BigDecimal(1000);
    private static final BigDecimal KIBI = new BigDecimal(1024);
    private static final Log log = LogFactory.getLog(ByteQuantity.class);

    public static long parse(String str) throws IllegalArgumentException {
        Matcher matcher = REGEX_PATTERN.matcher(str);
        if (!matcher.find()) {
            throw log.cannotParseQuantity(str);
        }
        try {
            String numberPart = matcher.group(1);
            String unit = matcher.group(2);
            BigDecimal number = new BigDecimal(numberPart);
            if (unit == null) {
                if (numberPart.contains(".")) {
                    throw log.cannotParseQuantity(str);
                }
                return number.longValueExact();
            }
            return Unit.valueOf(unit).toBytes(number);
        }
        catch (ArithmeticException e) {
            throw log.cannotParseQuantity(str);
        }
    }

    static /* synthetic */ BigDecimal access$000() {
        return KILO;
    }

    static /* synthetic */ BigDecimal access$100() {
        return KIBI;
    }

    private static enum Unit {
        B(ByteQuantity.access$000(), 0),
        KB(ByteQuantity.access$000(), 1),
        MB(ByteQuantity.access$000(), 2),
        GB(ByteQuantity.access$000(), 3),
        TB(ByteQuantity.access$000(), 4),
        KiB(ByteQuantity.access$100(), 1),
        MiB(ByteQuantity.access$100(), 2),
        GiB(ByteQuantity.access$100(), 3),
        TiB(ByteQuantity.access$100(), 4);

        BigDecimal base;
        int exp;

        private Unit(BigDecimal base, int exp) {
            this.base = base;
            this.exp = exp;
        }

        long toBytes(BigDecimal quantity) {
            return quantity.multiply(this.base.pow(this.exp)).longValueExact();
        }
    }
}

