/*
 * Decompiled with CFR 0.152.
 */
package org.icepear.echarts;

import java.util.ArrayList;
import java.util.List;
import org.icepear.echarts.Option;
import org.icepear.echarts.components.dataset.Dataset;
import org.icepear.echarts.components.legend.Legend;
import org.icepear.echarts.components.title.Title;
import org.icepear.echarts.components.tooltip.Tooltip;
import org.icepear.echarts.components.visualMap.ContinousVisualMap;
import org.icepear.echarts.origin.component.visualMap.VisualMapOption;
import org.icepear.echarts.origin.util.SeriesOption;

public abstract class Chart<T extends Chart<?, ?>, E extends SeriesOption> {
    protected final T self;
    protected final Class<E> seriesClazz;
    protected List<Dataset> datasets;
    protected List<SeriesOption> series;
    protected Option option;

    public Chart(Class<T> clazz, Class<E> seriesClazz) {
        this.self = (Chart)clazz.cast(this);
        this.seriesClazz = seriesClazz;
        this.datasets = new ArrayList<Dataset>();
        this.series = new ArrayList<SeriesOption>();
        this.option = new Option();
    }

    public Option getOption() {
        if (this.datasets.size() > 0) {
            this.option.setDataset(this.datasets.toArray(new Dataset[0]));
        }
        this.option.setSeries(this.series.toArray(new SeriesOption[0]));
        return this.option;
    }

    public T setTitle(String text) {
        this.option.setTitle(new Title().setText(text));
        return this.self;
    }

    public T setTitle(Title title) {
        this.option.setTitle(title);
        return this.self;
    }

    public T setLegend() {
        this.option.setLegend(new Legend());
        return this.self;
    }

    public T setLegend(Legend legend) {
        this.option.setLegend(legend);
        return this.self;
    }

    public T setTooltip(String trigger) {
        this.option.setTooltip(new Tooltip().setTrigger(trigger));
        return this.self;
    }

    public T setTooltip(Tooltip tooltip) {
        this.option.setTooltip(tooltip);
        return this.self;
    }

    public T addDataset(Object[] source) {
        this.datasets.add(new Dataset().setSource(source));
        return this.self;
    }

    public T addDataset(Object[][] source) {
        this.datasets.add(new Dataset().setSource(source));
        return this.self;
    }

    public T addDataset(Object[][][] source) {
        this.datasets.add(new Dataset().setSource(source));
        return this.self;
    }

    public T addDataset(Dataset dataset) {
        this.datasets.add(dataset);
        return this.self;
    }

    public T setVisualMap(Number min, Number max) {
        this.option.setVisualMap(new ContinousVisualMap().setMin(min).setMax(max));
        return this.self;
    }

    public T setVisualMap(VisualMapOption visualMap) {
        this.option.setVisualMap(visualMap);
        return this.self;
    }

    public T addSeries(Object[] data) {
        this.series.add((SeriesOption)this.createSeries((E)data));
        return this.self;
    }

    public T addSeries(Object[][] data) {
        this.series.add((SeriesOption)this.createSeries((E)data));
        return this.self;
    }

    public T addSeries(Object[][][] data) {
        this.series.add((SeriesOption)this.createSeries((E)data));
        return this.self;
    }

    public T addSeries(String name, Object[] data) {
        this.series.add((SeriesOption)this.createSeries(name, data));
        return this.self;
    }

    public T addSeries(String name, Object[][] data) {
        this.series.add((SeriesOption)this.createSeries(name, data));
        return this.self;
    }

    public T addSeries(String name, Object[][][] data) {
        this.series.add((SeriesOption)this.createSeries(name, data));
        return this.self;
    }

    public T addSeries(E series) {
        this.series.add((SeriesOption)this.createSeries(series));
        return this.self;
    }

    protected abstract E createSeries();

    protected E createSeries(Object data) {
        return (E)((SeriesOption)this.seriesClazz.cast(this.createSeries().setData(data)));
    }

    protected E createSeries(String name, Object data) {
        return (E)((SeriesOption)this.seriesClazz.cast(this.createSeries((E)data).setName(name)));
    }

    protected E createSeries(E series) {
        return series;
    }
}

