/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.schema.management.impl;

import org.hibernate.search.backend.elasticsearch.lowlevel.index.aliases.impl.IndexAliasDefinition;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.impl.IndexMetadata;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.RootTypeMapping;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.settings.impl.IndexSettings;
import org.hibernate.search.backend.elasticsearch.reporting.impl.ElasticsearchValidationMessages;
import org.hibernate.search.backend.elasticsearch.validation.impl.ElasticsearchPropertyMappingValidatorProvider;
import org.hibernate.search.backend.elasticsearch.validation.impl.IndexAliasDefinitionValidator;
import org.hibernate.search.backend.elasticsearch.validation.impl.IndexSettingsValidator;
import org.hibernate.search.backend.elasticsearch.validation.impl.RootTypeMappingValidator;
import org.hibernate.search.backend.elasticsearch.validation.impl.ValidationContextType;
import org.hibernate.search.backend.elasticsearch.validation.impl.ValidationErrorCollector;
import org.hibernate.search.backend.elasticsearch.validation.impl.Validator;
import org.hibernate.search.engine.reporting.spi.ContextualFailureCollector;

final class ElasticsearchSchemaValidator {
    private final Validator<IndexAliasDefinition> aliasDefinitionValidator = new IndexAliasDefinitionValidator();
    private final Validator<IndexSettings> indexSettingsValidator = new IndexSettingsValidator();
    private final Validator<RootTypeMapping> rootTypeMappingValidator;

    public ElasticsearchSchemaValidator(ElasticsearchPropertyMappingValidatorProvider propertyMappingValidatorProvider) {
        this.rootTypeMappingValidator = new RootTypeMappingValidator(propertyMappingValidatorProvider);
    }

    public void validate(IndexMetadata expectedIndexMetadata, IndexMetadata actualIndexMetadata, ContextualFailureCollector contextualFailureCollector) {
        ValidationErrorCollector errorCollector = new ValidationErrorCollector(contextualFailureCollector);
        this.validateAliases(errorCollector, expectedIndexMetadata, actualIndexMetadata);
        this.validateSettings(errorCollector, expectedIndexMetadata, actualIndexMetadata);
        this.validateMapping(errorCollector, expectedIndexMetadata, actualIndexMetadata);
    }

    public boolean isAliasesValid(IndexMetadata expectedIndexMetadata, IndexMetadata actualIndexMetadata) {
        ValidationErrorCollector errorCollector = new ValidationErrorCollector();
        this.validateAliases(errorCollector, expectedIndexMetadata, actualIndexMetadata);
        return !errorCollector.hasError();
    }

    private void validateAliases(ValidationErrorCollector errorCollector, IndexMetadata expectedIndexMetadata, IndexMetadata actualIndexMetadata) {
        this.aliasDefinitionValidator.validateAllIgnoreUnexpected(errorCollector, ValidationContextType.ALIAS, ElasticsearchValidationMessages.INSTANCE.aliasMissing(), expectedIndexMetadata.getAliases(), actualIndexMetadata.getAliases());
    }

    public boolean isSettingsValid(IndexMetadata expectedIndexMetadata, IndexMetadata actualIndexMetadata) {
        ValidationErrorCollector errorCollector = new ValidationErrorCollector();
        this.validateSettings(errorCollector, expectedIndexMetadata, actualIndexMetadata);
        return !errorCollector.hasError();
    }

    private void validateSettings(ValidationErrorCollector errorCollector, IndexMetadata expectedIndexMetadata, IndexMetadata actualIndexMetadata) {
        this.indexSettingsValidator.validate(errorCollector, expectedIndexMetadata.getSettings(), actualIndexMetadata.getSettings());
    }

    public boolean isMappingValid(IndexMetadata expectedIndexMetadata, IndexMetadata actualIndexMetadata) {
        ValidationErrorCollector errorCollector = new ValidationErrorCollector();
        this.validateMapping(errorCollector, expectedIndexMetadata, actualIndexMetadata);
        return !errorCollector.hasError();
    }

    private void validateMapping(ValidationErrorCollector errorCollector, IndexMetadata expectedIndexMetadata, IndexMetadata actualIndexMetadata) {
        this.rootTypeMappingValidator.validate(errorCollector, expectedIndexMetadata.getMapping(), actualIndexMetadata.getMapping());
    }
}

