/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge.time;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.fest.assertions.Assertions;
import org.hibernate.search.bridge.builtin.time.impl.ZonedDateTimeBridge;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ZonedDateTimeBridgeTest {
    private static final ZonedDateTimeBridge BRIDGE = ZonedDateTimeBridge.INSTANCE;
    private static final String MAX = "+9999999991231235959999999999+18:00";
    private static final String MIN = "-9999999990101000000000000000-18:00";
    private static final String CUSTOM = "-0000000010203040506000000007Europe/Paris";
    private static final ZonedDateTime MAX_VALUE = ZonedDateTime.of(LocalDateTime.MAX, ZoneOffset.MAX);
    private static final ZonedDateTime MIN_VALUE = ZonedDateTime.of(LocalDateTime.MIN, ZoneOffset.MIN);
    private static final ZonedDateTime CUSTOM_UTC = ZonedDateTime.of(LocalDate.of(-1, 2, 3), LocalTime.of(4, 5, 6, 7), ZoneId.of("Europe/Paris"));
    @Rule
    public final ExpectedException thrown = ExpectedException.none();

    @Test
    public void testMaxObjectToString() throws Exception {
        Assertions.assertThat((String)BRIDGE.objectToString((Object)MAX_VALUE)).isEqualTo((Object)MAX);
    }

    @Test
    public void testMinObjectToString() throws Exception {
        Assertions.assertThat((String)BRIDGE.objectToString((Object)MIN_VALUE)).isEqualTo((Object)MIN);
    }

    @Test
    public void testPaddingObjectToString() throws Exception {
        Assertions.assertThat((String)BRIDGE.objectToString((Object)CUSTOM_UTC)).isEqualTo((Object)CUSTOM);
    }

    @Test
    public void testMaxStringToObject() throws Exception {
        Assertions.assertThat((Object)BRIDGE.stringToObject(MAX)).isEqualTo((Object)MAX_VALUE);
    }

    @Test
    public void testMinStringToObject() throws Exception {
        Assertions.assertThat((Object)BRIDGE.stringToObject(MIN)).isEqualTo((Object)MIN_VALUE);
    }

    @Test
    public void testPaddingStringToObject() throws Exception {
        Assertions.assertThat((Object)BRIDGE.stringToObject(CUSTOM)).isEqualTo((Object)CUSTOM_UTC);
    }
}

