/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.syslog4j.server.impl.net.tcp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Iterator;
import javax.net.ServerSocketFactory;
import org.graylog2.syslog4j.SyslogRuntimeException;
import org.graylog2.syslog4j.server.SyslogServerEventIF;
import org.graylog2.syslog4j.server.SyslogServerIF;
import org.graylog2.syslog4j.server.impl.AbstractSyslogServer;
import org.graylog2.syslog4j.server.impl.net.tcp.TCPNetSyslogServerConfigIF;
import org.graylog2.syslog4j.util.SyslogUtility;

public class TCPNetSyslogServer
extends AbstractSyslogServer {
    protected ServerSocket serverSocket = null;
    protected final AbstractSyslogServer.Sessions sessions = new AbstractSyslogServer.Sessions();
    protected TCPNetSyslogServerConfigIF tcpNetSyslogServerConfig = null;

    @Override
    public void initialize() throws SyslogRuntimeException {
        this.tcpNetSyslogServerConfig = null;
        try {
            this.tcpNetSyslogServerConfig = (TCPNetSyslogServerConfigIF)this.syslogServerConfig;
        }
        catch (ClassCastException cce) {
            throw new SyslogRuntimeException("config must be of type TCPNetSyslogServerConfig");
        }
        if (this.syslogServerConfig == null) {
            throw new SyslogRuntimeException("config cannot be null");
        }
        if (this.tcpNetSyslogServerConfig.getBacklog() < 1) {
            this.tcpNetSyslogServerConfig.setBacklog(50);
        }
    }

    public AbstractSyslogServer.Sessions getSessions() {
        return this.sessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void shutdown() {
        super.shutdown();
        try {
            if (this.serverSocket != null) {
                if (this.syslogServerConfig.getShutdownWait() > 0L) {
                    SyslogUtility.sleep(this.syslogServerConfig.getShutdownWait());
                }
                this.serverSocket.close();
            }
            AbstractSyslogServer.Sessions sessions = this.sessions;
            synchronized (sessions) {
                Iterator i = this.sessions.getSockets();
                if (i != null) {
                    while (i.hasNext()) {
                        Socket s = (Socket)i.next();
                        s.close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.thread != null) {
            this.thread.interrupt();
            this.thread = null;
        }
    }

    protected ServerSocketFactory getServerSocketFactory() throws IOException {
        ServerSocketFactory serverSocketFactory = ServerSocketFactory.getDefault();
        return serverSocketFactory;
    }

    protected ServerSocket createServerSocket() throws IOException {
        ServerSocket newServerSocket = null;
        ServerSocketFactory factory = this.getServerSocketFactory();
        if (this.syslogServerConfig.getHost() != null) {
            InetAddress inetAddress = InetAddress.getByName(this.syslogServerConfig.getHost());
            newServerSocket = factory.createServerSocket(this.syslogServerConfig.getPort(), this.tcpNetSyslogServerConfig.getBacklog(), inetAddress);
        } else {
            newServerSocket = this.tcpNetSyslogServerConfig.getBacklog() < 1 ? factory.createServerSocket(this.syslogServerConfig.getPort()) : factory.createServerSocket(this.syslogServerConfig.getPort(), this.tcpNetSyslogServerConfig.getBacklog());
        }
        return newServerSocket;
    }

    @Override
    public void run() {
        try {
            this.serverSocket = this.createServerSocket();
            this.shutdown = false;
        }
        catch (SocketException se) {
            throw new SyslogRuntimeException(se);
        }
        catch (IOException ioe) {
            throw new SyslogRuntimeException(ioe);
        }
        TCPNetSyslogServer.handleInitialize(this);
        while (!this.shutdown) {
            try {
                Socket socket = this.serverSocket.accept();
                if (this.tcpNetSyslogServerConfig.getTimeout() > 0) {
                    socket.setSoTimeout(this.tcpNetSyslogServerConfig.getTimeout());
                }
                if (this.tcpNetSyslogServerConfig.getMaxActiveSockets() > 0 && this.sessions.size() >= this.tcpNetSyslogServerConfig.getMaxActiveSockets()) {
                    if (this.tcpNetSyslogServerConfig.getMaxActiveSocketsBehavior() == 1) {
                        try {
                            socket.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        socket = null;
                    } else if (this.tcpNetSyslogServerConfig.getMaxActiveSocketsBehavior() == 0) {
                        while (!this.shutdown && this.sessions.size() >= this.tcpNetSyslogServerConfig.getMaxActiveSockets() && socket.isConnected() && !socket.isClosed()) {
                            SyslogUtility.sleep(500L);
                        }
                    }
                }
                if (socket == null) continue;
                TCPNetSyslogSocketHandler handler = new TCPNetSyslogSocketHandler(this.sessions, this, socket);
                Thread t = new Thread(handler);
                t.start();
            }
            catch (SocketException se) {
                if (!"Socket closed".equals(se.getMessage())) continue;
                this.shutdown = true;
            }
            catch (IOException iOException) {}
        }
        TCPNetSyslogServer.handleDestroy(this);
    }

    public static class TCPNetSyslogSocketHandler
    implements Runnable {
        protected SyslogServerIF server = null;
        protected Socket socket = null;
        protected AbstractSyslogServer.Sessions sessions = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TCPNetSyslogSocketHandler(AbstractSyslogServer.Sessions sessions, SyslogServerIF server, Socket socket) {
            this.sessions = sessions;
            this.server = server;
            this.socket = socket;
            AbstractSyslogServer.Sessions sessions2 = this.sessions;
            synchronized (sessions2) {
                this.sessions.addSocket(socket);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            boolean timeout = false;
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                String line = br.readLine();
                if (line != null) {
                    AbstractSyslogServer.handleSessionOpen(this.sessions, this.server, this.socket);
                }
                while (line != null && line.length() != 0) {
                    SyslogServerEventIF event = TCPNetSyslogServer.createEvent(this.server.getConfig(), line, this.socket.getInetAddress());
                    AbstractSyslogServer.handleEvent(this.sessions, this.server, this.socket, event);
                    line = br.readLine();
                }
            }
            catch (SocketTimeoutException ste) {
                timeout = true;
            }
            catch (SocketException se) {
                AbstractSyslogServer.handleException(this.sessions, this.server, this.socket.getRemoteSocketAddress(), se);
                if (!"Socket closed".equals(se.getMessage())) {
                    // empty if block
                }
            }
            catch (IOException ioe) {
                AbstractSyslogServer.handleException(this.sessions, this.server, this.socket.getRemoteSocketAddress(), ioe);
            }
            try {
                AbstractSyslogServer.handleSessionClosed(this.sessions, this.server, this.socket, timeout);
                this.sessions.removeSocket(this.socket);
                this.socket.close();
                return;
            }
            catch (IOException ioe) {
                AbstractSyslogServer.handleException(this.sessions, this.server, this.socket.getRemoteSocketAddress(), ioe);
            }
        }
    }
}

