/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataUtils {
    public static List<Object[]> diffLists(List<?> oldList, List<?> newList) {
        ListDiff listDiff = new ListDiff(oldList, newList);
        listDiff.diff();
        return listDiff.getOps();
    }

    private static class ListDiff {
        private final List<?> oldList;
        private final List<?> newList;
        private int oldi = 0;
        private int newi = 0;
        private List<Object[]> ops = new ArrayList<Object[]>();
        private List<Integer> skipOld = new ArrayList<Integer>();
        private Map<Integer, Object[]> delayedNew = new HashMap<Integer, Object[]>();

        public ListDiff(List<?> oldList, List<?> newList) {
            this.oldList = oldList;
            this.newList = newList;
        }

        public List<Object[]> getOps() {
            return this.ops;
        }

        private void moveNew() {
            ++this.newi;
            while (this.delayedNew.containsKey(this.newi)) {
                for (Object op : this.delayedNew.get(this.newi)) {
                    this.ops.add((Object[])op);
                }
                ++this.newi;
            }
        }

        private int nextOld() {
            int i;
            for (i = this.oldi + 1; this.skipOld.contains(i) && i < this.oldList.size(); ++i) {
            }
            return i;
        }

        private int nextNew() {
            return this.newi + 1;
        }

        private int getIndex(int index) {
            for (Object[] op : this.ops) {
                if (op[0].equals(-1) && (Integer)op[1] <= index) {
                    --index;
                    continue;
                }
                if (!op[0].equals(1) || (Integer)op[1] > index) continue;
                ++index;
            }
            return index;
        }

        public void diff() {
            this.oldi = 0;
            while (this.oldi < this.oldList.size()) {
                if (!this.skipOld.contains(this.oldi)) {
                    if (this.oldi < this.oldList.size() && this.newi < this.newList.size() && this.oldList.get(this.oldi).equals(this.newList.get(this.newi))) {
                        this.moveNew();
                    } else {
                        int foundNext = -1;
                        if (this.newi < this.newList.size() - 1) {
                            for (int i = this.newi + 1; i < this.newList.size(); ++i) {
                                if (!this.newList.get(i).equals(this.oldList.get(this.oldi)) || this.delayedNew.containsKey(i)) continue;
                                foundNext = i;
                                break;
                            }
                        }
                        if (foundNext == -1) {
                            int oi = this.nextOld();
                            int ni = this.nextNew();
                            if (oi < this.oldList.size() && ni < this.newList.size() && this.oldList.get(oi).equals(this.newList.get(ni))) {
                                this.ops.add(new Object[]{0, this.getIndex(this.oldi), this.newList.get(this.newi)});
                                this.moveNew();
                            } else {
                                this.ops.add(new Object[]{-1, this.getIndex(this.oldi), this.oldList.get(this.oldi)});
                            }
                        } else if (this.oldi < this.oldList.size() - 1 && this.oldList.get(this.oldi + 1).equals(this.newList.get(this.newi))) {
                            this.ops.add(new Object[]{-1, this.getIndex(this.oldi), this.oldList.get(this.oldi)});
                            this.delayedNew.put(foundNext, new Object[]{new Object[]{1, foundNext, this.oldList.get(this.oldi)}});
                        } else {
                            while (this.newi < foundNext) {
                                int foundOld = -1;
                                if (this.oldi < this.oldList.size() - 1) {
                                    for (int i = this.oldi + 1; i < this.oldList.size(); ++i) {
                                        if (!this.newList.get(this.newi).equals(this.oldList.get(i)) || this.skipOld.contains(i)) continue;
                                        foundOld = i;
                                        break;
                                    }
                                }
                                if (foundOld >= 0) {
                                    this.ops.add(new Object[]{-1, this.getIndex(foundOld), this.oldList.get(foundOld)});
                                    this.skipOld.add(foundOld);
                                }
                                this.ops.add(new Object[]{1, this.newi, this.newList.get(this.newi)});
                                this.moveNew();
                            }
                            --this.oldi;
                        }
                    }
                }
                ++this.oldi;
            }
            while (this.newi < this.newList.size()) {
                this.ops.add(new Object[]{1, this.newi, this.newList.get(this.newi)});
                this.moveNew();
            }
        }
    }
}

