/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.webapp;

import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.granite.config.GraniteConfig;
import org.granite.config.flex.ServicesConfig;
import org.granite.messaging.webapp.RequestMap;
import org.granite.messaging.webapp.ServletGraniteContext;
import org.granite.messaging.webapp.SessionMap;

public class HttpGraniteContext
extends ServletGraniteContext {
    private static final String SESSION_LOCK_KEY = HttpGraniteContext.class.getName() + ".LOCK";
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private RequestMap requestMap = null;

    public static HttpGraniteContext createThreadIntance(GraniteConfig graniteConfig, ServicesConfig servicesConfig, ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) {
        HttpGraniteContext graniteContext = new HttpGraniteContext(graniteConfig, servicesConfig, servletContext, request, response);
        HttpGraniteContext.setCurrentInstance(graniteContext);
        return graniteContext;
    }

    protected HttpGraniteContext(GraniteConfig graniteConfig, ServicesConfig servicesConfig, ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) {
        super(graniteConfig, servicesConfig, servletContext, (String)null, request.getHeader("GDSClientType"));
        this.request = request;
        this.response = response;
    }

    @Override
    public HttpServletRequest getRequest() {
        return this.request;
    }

    @Override
    public HttpServletResponse getResponse() {
        return this.response;
    }

    @Override
    public String getSessionId() {
        return this.request.getSession(false) != null ? this.request.getSession().getId() : null;
    }

    @Override
    public HttpSession getSession(boolean create) {
        return this.request.getSession(create);
    }

    @Override
    public HttpSession getSession() {
        return this.request.getSession(true);
    }

    @Override
    public synchronized Object getSessionLock() {
        Object lock = this.request.getSession(true).getAttribute(SESSION_LOCK_KEY);
        if (lock == null) {
            lock = new Boolean(true);
            this.request.getSession(true).setAttribute(SESSION_LOCK_KEY, lock);
        }
        return lock;
    }

    @Override
    public Map<String, Object> getSessionMap() {
        return this.getSessionMap(true);
    }

    @Override
    public Map<String, Object> getSessionMap(boolean create) {
        if (this.sessionMap == null && (create || this.request.getSession(false) != null)) {
            this.sessionMap = new SessionMap(this.request);
        }
        return this.sessionMap;
    }

    @Override
    public Map<String, Object> getRequestMap() {
        if (this.requestMap == null) {
            this.requestMap = new RequestMap(this.request);
        }
        return this.requestMap;
    }
}

