/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.webapp;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.granite.config.GraniteConfig;
import org.granite.config.GraniteConfigListener;
import org.granite.config.ServletGraniteConfig;
import org.granite.config.flex.ServicesConfig;
import org.granite.config.flex.ServletServicesConfig;
import org.granite.context.AMFContextImpl;
import org.granite.context.GraniteContext;
import org.granite.logging.Logger;
import org.granite.messaging.amf.AMF0Message;
import org.granite.messaging.amf.io.AMF0Deserializer;
import org.granite.messaging.amf.io.AMF0Serializer;
import org.granite.messaging.jmf.JMFDeserializer;
import org.granite.messaging.jmf.JMFSerializer;
import org.granite.messaging.jmf.SharedContext;
import org.granite.messaging.webapp.HttpGraniteContext;
import org.granite.util.ContentType;
import org.granite.util.ServletParams;

public class AMFMessageFilter
implements Filter {
    private static final Logger log = Logger.getLogger(AMFMessageFilter.class);
    protected FilterConfig config = null;
    protected GraniteConfig graniteConfig = null;
    protected ServicesConfig servicesConfig = null;
    protected Integer inputBufferSize = null;
    protected Integer outputBufferSize = null;
    protected boolean closeStreams = true;
    protected SharedContext jmfSharedContext = null;

    public void init(FilterConfig config) throws ServletException {
        this.config = config;
        this.graniteConfig = ServletGraniteConfig.loadConfig(config.getServletContext());
        this.servicesConfig = ServletServicesConfig.loadConfig(config.getServletContext());
        this.closeStreams = ServletParams.get(config, "closeStreams", Boolean.TYPE, Boolean.valueOf(true));
        this.inputBufferSize = ServletParams.get(config, "inputBufferSize", Integer.TYPE, null);
        this.outputBufferSize = ServletParams.get(config, "outputBufferSize", Integer.TYPE, null);
        if (this.inputBufferSize != null && this.inputBufferSize <= 0) {
            throw new ServletException("Illegal value for inputBufferSize=" + this.inputBufferSize + " (should be > 0, fix your web.xml)");
        }
        if (this.outputBufferSize != null && this.outputBufferSize <= 0) {
            throw new ServletException("Illegal value for outputBufferSize=" + this.outputBufferSize + " (should be > 0, fix your web.xml)");
        }
        log.info("Using configuration: {closeStreams=%s, inputBufferSize=%s, outputBufferSize=%s}", this.closeStreams, this.inputBufferSize, this.outputBufferSize);
        this.jmfSharedContext = GraniteConfigListener.getSharedContext(config.getServletContext());
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        if (!(req instanceof HttpServletRequest) || !(resp instanceof HttpServletResponse)) {
            throw new ServletException("Not in HTTP context: " + req + ", " + resp);
        }
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)resp;
        if (ContentType.JMF_AMF.mimeType().equals(request.getContentType())) {
            this.doJMFAMFFilter(request, response, chain);
        } else {
            this.doAMFFilter(request, response, chain);
        }
    }

    protected void doAMFFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        log.debug(">> Incoming AMF0 request from: %s", request.getRequestURL());
        Object is = null;
        OutputStream os = null;
        try {
            is = this.inputBufferSize != null ? new BufferedInputStream((InputStream)request.getInputStream(), this.inputBufferSize) : request.getInputStream();
            HttpGraniteContext context = HttpGraniteContext.createThreadIntance(this.graniteConfig, this.servicesConfig, this.config.getServletContext(), request, response);
            AMFContextImpl amf = (AMFContextImpl)context.getAMFContext();
            log.debug(">> Deserializing AMF0 request...", new Object[0]);
            AMF0Deserializer deserializer = new AMF0Deserializer((InputStream)is);
            AMF0Message amf0Request = deserializer.getAMFMessage();
            amf.setAmf0Request(amf0Request);
            log.debug(">> Chaining AMF0 request: %s", amf0Request);
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            AMF0Message amf0Response = amf.getAmf0Response();
            log.debug("<< Serializing AMF0 response: %s", amf0Response);
            response.setStatus(200);
            response.setContentType(ContentType.AMF.mimeType());
            response.setDateHeader("Expire", 0L);
            response.setHeader("Cache-Control", "no-store");
            if (this.outputBufferSize != null) {
                response.setBufferSize(this.outputBufferSize.intValue());
            }
            os = response.getOutputStream();
            AMF0Serializer serializer = new AMF0Serializer(os);
            serializer.serializeMessage(amf0Response);
            response.flushBuffer();
        }
        catch (IOException e) {
            if ("org.apache.catalina.connector.ClientAbortException".equals(e.getClass().getName())) {
                log.debug(e, "Connection closed by client", new Object[0]);
            } else {
                log.error(e, "AMF message error", new Object[0]);
            }
            throw e;
        }
        catch (Exception e) {
            log.error(e, "AMF message error", new Object[0]);
            throw new ServletException((Throwable)e);
        }
        finally {
            if (this.closeStreams) {
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException e) {
                        log.error(e, "Error while closing request input stream", new Object[0]);
                    }
                }
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException e) {
                        log.error(e, "Error while closing response output stream", new Object[0]);
                    }
                }
            }
            GraniteContext.release();
        }
    }

    protected void doJMFAMFFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        log.debug(">> Incoming JMF+AMF request from: %s", request.getRequestURL());
        if (this.jmfSharedContext == null) {
            throw GraniteConfigListener.newSharedContextNotInitializedException();
        }
        ServletInputStream is = null;
        OutputStream os = null;
        try {
            is = request.getInputStream();
            HttpGraniteContext context = HttpGraniteContext.createThreadIntance(this.graniteConfig, this.servicesConfig, this.config.getServletContext(), request, response);
            AMFContextImpl amf = (AMFContextImpl)context.getAMFContext();
            log.debug(">> Deserializing JMF+AMF request...", new Object[0]);
            JMFDeserializer deserializer = new JMFDeserializer((InputStream)is, this.jmfSharedContext);
            AMF0Message amf0Request = (AMF0Message)deserializer.readObject();
            amf.setAmf0Request(amf0Request);
            log.debug(">> Chaining AMF0 request: %s", amf0Request);
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            AMF0Message amf0Response = amf.getAmf0Response();
            log.debug("<< Serializing JMF+AMF response: %s", amf0Response);
            response.setStatus(200);
            response.setContentType(ContentType.JMF_AMF.mimeType());
            response.setDateHeader("Expire", 0L);
            response.setHeader("Cache-Control", "no-store");
            os = response.getOutputStream();
            JMFSerializer serializer = new JMFSerializer(os, this.jmfSharedContext);
            serializer.writeObject(amf0Response);
            response.flushBuffer();
        }
        catch (IOException e) {
            if ("org.apache.catalina.connector.ClientAbortException".equals(e.getClass().getName())) {
                log.debug(e, "Connection closed by client", new Object[0]);
            } else {
                log.error(e, "JMF+AMF message error", new Object[0]);
            }
            throw e;
        }
        catch (Exception e) {
            log.error(e, "JMF+AMF message error", new Object[0]);
            throw new ServletException((Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    log.error(e, "Error while closing request input stream", new Object[0]);
                }
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    log.error(e, "Error while closing response output stream", new Object[0]);
                }
            }
            GraniteContext.release();
        }
    }

    public void destroy() {
        this.config = null;
        this.graniteConfig = null;
        this.servicesConfig = null;
        this.jmfSharedContext = null;
    }
}

