/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.jmf.codec.std.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.Time;
import org.granite.messaging.jmf.DumpContext;
import org.granite.messaging.jmf.InputContext;
import org.granite.messaging.jmf.OutputContext;
import org.granite.messaging.jmf.codec.std.SqlTimeCodec;
import org.granite.messaging.jmf.codec.std.impl.AbstractStandardCodec;

public class SqlTimeCodecImpl
extends AbstractStandardCodec<Time>
implements SqlTimeCodec {
    @Override
    public int getObjectType() {
        return 248;
    }

    @Override
    public Class<?> getObjectClass() {
        return Time.class;
    }

    @Override
    public void encode(OutputContext ctx, Time v) throws IOException {
        OutputStream os = ctx.getOutputStream();
        os.write(248);
        long t = v.getTime();
        os.write((int)(t >> 56));
        os.write((int)(t >> 48));
        os.write((int)(t >> 40));
        os.write((int)(t >> 32));
        os.write((int)(t >> 24));
        os.write((int)(t >> 16));
        os.write((int)(t >> 8));
        os.write((int)t);
    }

    @Override
    public Time decode(InputContext ctx, int parameterizedJmfType) throws IOException {
        int jmfType = ctx.getSharedContext().getCodecRegistry().extractJmfType(parameterizedJmfType);
        if (jmfType != 248) {
            throw this.newBadTypeJMFEncodingException(jmfType, parameterizedJmfType);
        }
        long t = (long)ctx.safeRead() << 56;
        t |= (long)ctx.safeRead() << 48;
        t |= (long)ctx.safeRead() << 40;
        t |= (long)ctx.safeRead() << 32;
        t |= (long)ctx.safeRead() << 24;
        t |= (long)ctx.safeRead() << 16;
        t |= (long)ctx.safeRead() << 8;
        return new Time(t |= (long)ctx.safeRead());
    }

    @Override
    public void dump(DumpContext ctx, int parameterizedJmfType) throws IOException {
        int jmfType = ctx.getSharedContext().getCodecRegistry().extractJmfType(parameterizedJmfType);
        switch (jmfType) {
            case 248: {
                ctx.indentPrintLn(Time.class.getName() + ": " + this.decode(ctx, parameterizedJmfType));
                break;
            }
            default: {
                throw this.newBadTypeJMFEncodingException(jmfType, parameterizedJmfType);
            }
        }
    }
}

