/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.jmf.codec.std.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.Date;
import org.granite.messaging.jmf.DumpContext;
import org.granite.messaging.jmf.InputContext;
import org.granite.messaging.jmf.OutputContext;
import org.granite.messaging.jmf.codec.std.SqlDateCodec;
import org.granite.messaging.jmf.codec.std.impl.AbstractStandardCodec;

public class SqlDateCodecImpl
extends AbstractStandardCodec<Date>
implements SqlDateCodec {
    @Override
    public int getObjectType() {
        return 127;
    }

    @Override
    public Class<?> getObjectClass() {
        return Date.class;
    }

    @Override
    public void encode(OutputContext ctx, Date v) throws IOException {
        OutputStream os = ctx.getOutputStream();
        os.write(127);
        long t = v.getTime();
        os.write((int)(t >> 56));
        os.write((int)(t >> 48));
        os.write((int)(t >> 40));
        os.write((int)(t >> 32));
        os.write((int)(t >> 24));
        os.write((int)(t >> 16));
        os.write((int)(t >> 8));
        os.write((int)t);
    }

    @Override
    public Date decode(InputContext ctx, int parameterizedJmfType) throws IOException {
        int jmfType = ctx.getSharedContext().getCodecRegistry().extractJmfType(parameterizedJmfType);
        if (jmfType != 127) {
            throw this.newBadTypeJMFEncodingException(jmfType, parameterizedJmfType);
        }
        long t = (long)ctx.safeRead() << 56;
        t |= (long)ctx.safeRead() << 48;
        t |= (long)ctx.safeRead() << 40;
        t |= (long)ctx.safeRead() << 32;
        t |= (long)ctx.safeRead() << 24;
        t |= (long)ctx.safeRead() << 16;
        t |= (long)ctx.safeRead() << 8;
        return new Date(t |= (long)ctx.safeRead());
    }

    @Override
    public void dump(DumpContext ctx, int parameterizedJmfType) throws IOException {
        int jmfType = ctx.getSharedContext().getCodecRegistry().extractJmfType(parameterizedJmfType);
        switch (jmfType) {
            case 127: {
                ctx.indentPrintLn(Date.class.getName() + ": " + this.decode(ctx, parameterizedJmfType));
                break;
            }
            default: {
                throw this.newBadTypeJMFEncodingException(jmfType, parameterizedJmfType);
            }
        }
    }
}

