/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.jmf.codec.std.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import org.granite.messaging.jmf.CodecRegistry;
import org.granite.messaging.jmf.DumpContext;
import org.granite.messaging.jmf.InputContext;
import org.granite.messaging.jmf.JMFEncodingException;
import org.granite.messaging.jmf.OutputContext;
import org.granite.messaging.jmf.codec.StandardCodec;
import org.granite.messaging.jmf.codec.std.HashSetCodec;
import org.granite.messaging.jmf.codec.std.impl.AbstractIntegerStringCodec;

public class HashSetCodecImpl
extends AbstractIntegerStringCodec<HashSet<?>>
implements HashSetCodec {
    @Override
    public int getObjectType() {
        return 11;
    }

    @Override
    public Class<?> getObjectClass() {
        return HashSet.class;
    }

    @Override
    public void encode(OutputContext ctx, HashSet<?> v) throws IOException {
        OutputStream os = ctx.getOutputStream();
        int indexOfStoredObject = ctx.indexOfStoredObjects(v);
        if (indexOfStoredObject >= 0) {
            AbstractIntegerStringCodec.IntegerComponents ics = this.intComponents(indexOfStoredObject);
            os.write(0x80 | ics.length << 5 | 0xB);
            this.writeIntData(ctx, ics);
        } else {
            ctx.addToStoredObjects(v);
            Object[] snapshot = v.toArray();
            AbstractIntegerStringCodec.IntegerComponents ics = this.intComponents(snapshot.length);
            os.write(ics.length << 5 | 0xB);
            this.writeIntData(ctx, ics);
            for (Object element : snapshot) {
                ctx.writeObject(element);
            }
        }
    }

    @Override
    public HashSet<?> decode(InputContext ctx, int parameterizedJmfType) throws IOException, ClassNotFoundException {
        int jmfType = ctx.getSharedContext().getCodecRegistry().extractJmfType(parameterizedJmfType);
        if (jmfType != 11) {
            throw this.newBadTypeJMFEncodingException(jmfType, parameterizedJmfType);
        }
        int indexOrLength = this.readIntData(ctx, parameterizedJmfType >> 5 & 3, false);
        if ((parameterizedJmfType & 0x80) != 0) {
            return (HashSet)ctx.getSharedObject(indexOrLength);
        }
        HashSet<Object> v = new HashSet<Object>(indexOrLength);
        ctx.addSharedObject(v);
        for (int index = 0; index < indexOrLength; ++index) {
            v.add(ctx.readObject());
        }
        return v;
    }

    @Override
    public void dump(DumpContext ctx, int parameterizedJmfType) throws IOException {
        CodecRegistry codecRegistry = ctx.getSharedContext().getCodecRegistry();
        int jmfType = codecRegistry.extractJmfType(parameterizedJmfType);
        if (jmfType != 11) {
            throw this.newBadTypeJMFEncodingException(jmfType, parameterizedJmfType);
        }
        int indexOrLength = this.readIntData(ctx, parameterizedJmfType >> 5 & 3, false);
        if ((parameterizedJmfType & 0x80) != 0) {
            String v = (String)ctx.getSharedObject(indexOrLength);
            ctx.indentPrintLn("<" + v + "@" + indexOrLength + ">");
            return;
        }
        String v = HashSet.class.getName() + "[" + indexOrLength + "]";
        int indexOfStoredObject = ctx.addSharedObject(v);
        ctx.indentPrintLn(v + "@" + indexOfStoredObject + " {");
        ctx.incrIndent(1);
        for (int index = 0; index < indexOrLength; ++index) {
            parameterizedJmfType = ctx.safeRead();
            jmfType = codecRegistry.extractJmfType(parameterizedJmfType);
            StandardCodec codec = codecRegistry.getCodec(jmfType);
            if (codec == null) {
                throw new JMFEncodingException("No codec for JMF type: " + jmfType);
            }
            codec.dump(ctx, parameterizedJmfType);
        }
        ctx.incrIndent(-1);
        ctx.indentPrintLn("}");
    }
}

