/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.jetty8;

import flex.messaging.messages.AsyncMessage;
import flex.messaging.messages.Message;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.websocket.WebSocket;
import org.granite.context.GraniteContext;
import org.granite.context.SimpleGraniteContext;
import org.granite.gravity.AbstractChannel;
import org.granite.gravity.AsyncHttpContext;
import org.granite.gravity.Gravity;
import org.granite.gravity.GravityConfig;
import org.granite.gravity.jetty8.JettyWebSocketChannelFactory;
import org.granite.logging.Logger;
import org.granite.messaging.jmf.JMFDeserializer;
import org.granite.messaging.jmf.JMFSerializer;
import org.granite.messaging.webapp.ServletGraniteContext;
import org.granite.util.ContentType;

public class JettyWebSocketChannel
extends AbstractChannel
implements WebSocket,
WebSocket.OnBinaryMessage {
    private static final Logger log = Logger.getLogger(JettyWebSocketChannel.class);
    private HttpSession session;
    private ContentType contentType;
    private WebSocket.Connection connection;
    private Message connectAckMessage;

    public JettyWebSocketChannel(Gravity gravity, String id, JettyWebSocketChannelFactory factory, String clientType) {
        super(gravity, id, factory, clientType);
    }

    public void setSession(HttpSession session) {
        this.session = session;
    }

    public void setConnectAckMessage(Message ackMessage) {
        this.connectAckMessage = ackMessage;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOpen(WebSocket.Connection connection) {
        this.connection = connection;
        this.connection.setMaxIdleTime((int)this.getGravity().getGravityConfig().getChannelIdleTimeoutMillis());
        log.debug("Channel %s websocket connection onOpen", this.getId());
        if (this.connectAckMessage == null) {
            return;
        }
        try {
            this.initializeRequest();
            byte[] resultData = this.serialize(this.getGravity(), new Message[]{this.connectAckMessage});
            connection.sendMessage(resultData, 0, resultData.length);
            this.connectAckMessage = null;
        }
        catch (IOException e) {
            log.error(e, "Channel %s could not send connect acknowledge", this.getId());
        }
        finally {
            JettyWebSocketChannel.cleanupRequest();
        }
    }

    public void onClose(int closeCode, String message) {
        log.debug("Channel %s websocket connection onClose %d, %s", this.getId(), closeCode, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(byte[] data, int offset, int length) {
        log.debug("Channel %s websocket connection onMessage %d", this.getId(), data.length);
        try {
            this.initializeRequest();
            Message[] messages = this.deserialize(this.getGravity(), data, offset, length);
            log.debug(">> [AMF3 REQUESTS] %s", new Object[]{messages});
            Message[] responses = null;
            boolean accessed = false;
            int responseIndex = 0;
            for (int i = 0; i < messages.length; ++i) {
                Message message = messages[i];
                Message response = this.getGravity().handleMessage(this.getFactory(), message);
                String channelId = (String)message.getClientId();
                if (!accessed) {
                    accessed = this.getGravity().access(channelId);
                }
                if (response == null) continue;
                responses = responses == null ? new Message[1] : Arrays.copyOf(responses, responses.length + 1);
                responses[responseIndex++] = response;
            }
            if (responses != null && responses.length > 0) {
                log.debug("<< [AMF3 RESPONSES] %s", new Object[]{responses});
                byte[] resultData = this.serialize(this.getGravity(), responses);
                this.connection.sendMessage(resultData, 0, resultData.length);
            }
        }
        catch (ClassNotFoundException e) {
            log.error(e, "Could not handle incoming message data", new Object[0]);
        }
        catch (IOException e) {
            log.error(e, "Could not handle incoming message data", new Object[0]);
        }
        finally {
            JettyWebSocketChannel.cleanupRequest();
        }
    }

    private Gravity initializeRequest() {
        if (this.session != null) {
            ServletGraniteContext.createThreadInstance(this.gravity.getGraniteConfig(), this.gravity.getServicesConfig(), this.session.getServletContext(), this.session, this.clientType);
        } else {
            SimpleGraniteContext.createThreadInstance(this.gravity.getGraniteConfig(), this.gravity.getServicesConfig(), this.sessionId, new HashMap<String, Object>(), this.clientType);
        }
        return this.gravity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message[] deserialize(Gravity gravity, byte[] data, int offset, int length) throws ClassNotFoundException, IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(data, offset, length);
        try {
            Message[] messages = null;
            if (ContentType.JMF_AMF.equals((Object)this.contentType)) {
                JMFDeserializer deserializer = new JMFDeserializer(is, gravity.getSharedContext());
                messages = (Message[])deserializer.readObject();
            } else {
                ObjectInput amf3Deserializer = gravity.getGraniteConfig().newAMF3Deserializer(is);
                Object[] objects = (Object[])amf3Deserializer.readObject();
                messages = new Message[objects.length];
                System.arraycopy(objects, 0, messages, 0, objects.length);
            }
            Message[] messageArray = messages;
            return messageArray;
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] serialize(Gravity gravity, Message[] messages) throws IOException {
        ByteArrayOutputStream os = null;
        try {
            os = new ByteArrayOutputStream(200 * messages.length);
            if (ContentType.JMF_AMF.equals((Object)this.contentType)) {
                JMFSerializer serializer = new JMFSerializer(os, gravity.getSharedContext());
                serializer.writeObject(messages);
            } else {
                ObjectOutput amf3Serializer = gravity.getGraniteConfig().newAMF3Serializer(os);
                amf3Serializer.writeObject(messages);
                os.flush();
            }
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }

    private static void cleanupRequest() {
        GraniteContext.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean runReceived(AsyncHttpContext asyncHttpContext) {
        LinkedList messages = null;
        try {
            this.receivedQueueLock.lock();
            try {
                if (this.receivedQueue.isEmpty()) {
                    boolean bl = false;
                    return bl;
                }
                messages = this.receivedQueue;
                this.receivedQueue = new LinkedList();
            }
            finally {
                this.receivedQueueLock.unlock();
            }
            if (this.connection == null || !this.connection.isOpen()) {
                boolean bl = false;
                return bl;
            }
            Message[] messagesArray = new AsyncMessage[messages.size()];
            int i = 0;
            for (AsyncMessage message : messages) {
                messagesArray[i++] = message;
            }
            Gravity gravity = this.getGravity();
            this.initializeRequest();
            log.debug("<< [MESSAGES for channel=%s] %s", this, messagesArray);
            byte[] msg = this.serialize(gravity, messagesArray);
            if (msg.length > 16000) {
                int count = msg.length / 2000;
                int chunkSize = Math.max(1, messagesArray.length / count);
                for (int index = 0; index < messagesArray.length; index += chunkSize) {
                    Message[] chunk = (AsyncMessage[])Arrays.copyOfRange(messagesArray, index, Math.min(messagesArray.length, index + chunkSize));
                    msg = this.serialize(gravity, chunk);
                    log.debug("Send binary message: %d msgs (%d bytes)", chunk.length, msg.length);
                    this.connection.sendMessage(msg, 0, msg.length);
                }
            } else {
                this.connection.sendMessage(msg, 0, msg.length);
                log.debug("Send binary message: %d msgs (%d bytes)", messagesArray.length, msg.length);
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            log.warn(e, "Could not send messages to channel: %s (retrying later)", this);
            GravityConfig gravityConfig = this.getGravity().getGravityConfig();
            if (gravityConfig.isRetryOnError()) {
                this.receivedQueueLock.lock();
                try {
                    if (this.receivedQueue.size() + messages.size() > gravityConfig.getMaxMessagesQueuedPerChannel()) {
                        log.warn("Channel %s has reached its maximum queue capacity %s (throwing %s messages)", this, gravityConfig.getMaxMessagesQueuedPerChannel(), messages.size());
                    } else {
                        this.receivedQueue.addAll(0, messages);
                    }
                }
                finally {
                    this.receivedQueueLock.unlock();
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            try {
                GraniteContext.release();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        try {
            super.destroy();
        }
        finally {
            this.close();
        }
    }

    @Override
    public void close() {
        if (this.connection != null) {
            this.connection.close(1000, "Channel closed");
            this.connection = null;
        }
    }

    @Override
    protected boolean hasAsyncHttpContext() {
        return true;
    }

    @Override
    protected void releaseAsyncHttpContext(AsyncHttpContext context) {
    }

    @Override
    protected AsyncHttpContext acquireAsyncHttpContext() {
        return null;
    }
}

