/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.adapters;

import flex.messaging.messages.AsyncMessage;
import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.Message;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.granite.config.flex.Adapter;
import org.granite.config.flex.Destination;
import org.granite.context.GraniteContext;
import org.granite.gravity.Gravity;
import org.granite.gravity.adapters.ServiceAdapter;
import org.granite.gravity.adapters.SimpleServiceAdapter;
import org.granite.logging.Logger;
import org.granite.messaging.service.ServiceException;
import org.granite.util.TypeUtil;

public class AdapterFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(AdapterFactory.class);
    private static final ReentrantLock lock = new ReentrantLock();
    private Gravity gravity;
    private Map<String, ServiceAdapter> adaptersCache = new ConcurrentHashMap<String, ServiceAdapter>();
    private List<ServiceAdapter> adapters = new ArrayList<ServiceAdapter>();
    private static Class<SimpleServiceAdapter> defaultAdapterClass = SimpleServiceAdapter.class;

    public AdapterFactory(Gravity gravity) {
        this.gravity = gravity;
    }

    public ServiceAdapter getServiceAdapter(Message request) throws ServiceException {
        String messageType = request.getClass().getName();
        if (request instanceof CommandMessage) {
            messageType = ((CommandMessage)request).getMessageRefType();
        }
        if (messageType == null) {
            messageType = AsyncMessage.class.getName();
        }
        String destinationId = request.getDestination();
        return this.getServiceAdapter(messageType, destinationId);
    }

    public ServiceAdapter getServiceAdapter(String messageType, String destinationId) throws ServiceException {
        GraniteContext context = GraniteContext.getCurrentInstance();
        log.debug(">> Finding serviceAdapter for messageType: %s and destinationId: %s", messageType, destinationId);
        Destination destination = context.getServicesConfig().findDestinationById(messageType, destinationId);
        if (destination == null) {
            log.debug(">> No destination found: %s", destinationId);
            return null;
        }
        Adapter adapter = destination.getAdapter();
        String key = null;
        if (adapter != null) {
            log.debug(">> Found adapterRef: %s", adapter.getId());
            key = AdapterFactory.class.getName() + '@' + destination.getId() + '.' + adapter.getId();
        } else {
            key = defaultAdapterClass.getName() + '@' + destination.getId();
        }
        return this.getServiceAdapter(this.adaptersCache, context, destination, key, adapter != null ? adapter.getId() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceAdapter getServiceAdapter(Map<String, ServiceAdapter> cache, GraniteContext context, Destination destination, String key, String adapterId) {
        lock.lock();
        try {
            ServiceAdapter serviceAdapter = cache.get(key);
            if (serviceAdapter == null) {
                log.debug(">> No cached factory for: %s", adapterId);
                Adapter config = destination.getAdapter();
                try {
                    Class<SimpleServiceAdapter> clazz = adapterId != null ? TypeUtil.forName(config.getClassName(), ServiceAdapter.class) : defaultAdapterClass;
                    serviceAdapter = clazz.newInstance();
                    serviceAdapter.setId(adapterId);
                    serviceAdapter.setGravity(this.gravity);
                    serviceAdapter.configure(config.getProperties(), destination.getProperties());
                    serviceAdapter.start();
                    this.adapters.add(serviceAdapter);
                }
                catch (ServiceException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new ServiceException("Could not instantiate serviceAdapter: " + config, e);
                }
                cache.put(key, serviceAdapter);
            } else {
                log.debug(">> Found a cached serviceAdapter for ref: %s", destination.getAdapter());
            }
            log.debug("<< Returning serviceAdapter: %s", serviceAdapter);
            serviceAdapter.setDestination(destination);
            ServiceAdapter serviceAdapter2 = serviceAdapter;
            return serviceAdapter2;
        }
        finally {
            lock.unlock();
        }
    }

    public void stopAll() {
        for (ServiceAdapter adapter : this.adapters) {
            adapter.stop();
        }
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String append) {
        return super.toString() + " {" + (append != null ? append : "") + "\n}";
    }
}

